/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.JukeboxInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImmersiveJukebox
extends AbstractBlockEntityImmersive<JukeboxBlockEntity, JukeboxInfo> {
    public ImmersiveJukebox() {
        super(1);
    }

    @Override
    public boolean isVROnly() {
        return true;
    }

    @Override
    protected void initInfo(JukeboxInfo info) {
        Vec3 topCenter = this.getTopCenterOfBlock(((JukeboxBlockEntity)info.getBlockEntity()).m_58899_());
        info.setPosition(0, topCenter);
        AABB hitbox = this.createHitbox(topCenter, 0.0625f);
        hitbox = hitbox.m_82377_(0.0, 0.0, 0.25);
        info.setHitbox(0, hitbox);
    }

    @Override
    protected void render(JukeboxInfo info, PoseStack stack, boolean isInVR) {
        this.renderHitbox(stack, info.getHitbox(0), info.getPosition(0));
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(JukeboxInfo info, int slotNum) {
        return false;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isJukebox(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveJukebox;
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useJukeboxImmersion;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        if (!VRPluginVerify.clientInVR) {
            return;
        }
        Network.INSTANCE.sendToServer((Object)new SwapPacket(info.getBlockPosition(), 0, hand));
    }

    @Override
    public JukeboxInfo getNewInfo(BlockEntity tileEnt) {
        return new JukeboxInfo((JukeboxBlockEntity)tileEnt, this.getTickTime());
    }

    @Override
    public int getTickTime() {
        return 100;
    }

    @Override
    public boolean shouldRender(JukeboxInfo info, boolean isInVR) {
        return ((JukeboxBlockEntity)info.getBlockEntity()).m_58904_() != null && ((JukeboxBlockEntity)info.getBlockEntity()).m_58904_().m_8055_(((JukeboxBlockEntity)info.getBlockEntity()).m_58899_().m_121945_(Direction.UP)).m_60795_() && info.readyToRender();
    }
}

