/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.RepeaterInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.SetRepeaterPacket;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ImmersiveRepeater
extends AbstractImmersive<RepeaterInfo> {
    public ImmersiveRepeater() {
        super(2);
    }

    @Override
    public boolean isVROnly() {
        return true;
    }

    @Override
    protected void initInfo(RepeaterInfo info) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition());
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Direction forwardDir = facing.m_122424_();
        Vec3 forward = Vec3.m_82528_((Vec3i)forwardDir.m_122436_());
        Vec3 centerPos = this.getTopCenterOfBlock(info.getBlockPosition()).m_82520_(0.0, -0.675, 0.0);
        info.setPosition(0, centerPos.m_82549_(forward.m_82542_(0.0625, 0.0, 0.0625)));
        info.setPosition(1, centerPos.m_82549_(forward.m_82542_(-0.0625, 0.0, -0.0625)));
        info.setPosition(2, centerPos.m_82549_(forward.m_82542_(-0.1875, 0.0, -0.1875)));
        info.setPosition(3, centerPos.m_82549_(forward.m_82542_(-0.3125, 0.0, -0.3125)));
        for (int i = 0; i <= 3; ++i) {
            info.setHitbox(i, this.createHitbox(info.getPosition(i), 0.071428575f).m_82377_(0.0, 0.2, 0.0));
        }
    }

    @Override
    protected void doTick(RepeaterInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (!(Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition()).m_60734_() instanceof RepeaterBlock)) {
            info.remove();
            return;
        }
        if (isInVR) {
            BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition());
            for (int c = 0; c <= 1; ++c) {
                Vec3 pos = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController(c).position();
                Optional<Integer> hit = Util.getClosestIntersect(pos, info.getAllHitboxes(), info.getAllPositions());
                int repeaterValue = (Integer)state.m_61143_((Property)RepeaterBlock.f_55798_);
                if (hit.isPresent()) {
                    int delayHit = hit.get() + 1;
                    if (delayHit == repeaterValue) {
                        info.grabbedCurrent[c] = true;
                        continue;
                    }
                    if (!info.grabbedCurrent[c]) continue;
                    Util.setRepeater((Level)Minecraft.m_91087_().f_91073_, info.getBlockPosition(), delayHit);
                    Network.INSTANCE.sendToServer((Object)new SetRepeaterPacket(info.getBlockPosition(), delayHit));
                    continue;
                }
                info.grabbedCurrent[c] = false;
            }
        }
    }

    @Override
    public boolean shouldRender(RepeaterInfo info, boolean isInVR) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level != null && level.m_8055_(info.getBlockPosition().m_7494_()).m_60795_() && info.readyToRender();
    }

    @Override
    protected void render(RepeaterInfo info, PoseStack stack, boolean isInVR) {
        for (int i = 0; i <= 3; ++i) {
            this.renderHitbox(stack, info.getHitbox(i), info.getPosition(i));
        }
    }

    @Override
    protected boolean enabledInConfig() {
        return ActiveConfig.useRepeaterImmersion;
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(RepeaterInfo info, int slotNum) {
        return false;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isRepeater(pos, state, tileEntity, level);
    }

    @Override
    public void trackObject(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        for (RepeaterInfo info : this.getTrackedObjects()) {
            if (!info.getBlockPosition().equals((Object)pos)) continue;
            info.setTicksLeft(80);
            return;
        }
        this.infos.add(new RepeaterInfo(pos));
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveRepeater;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
    }
}

