/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.subscribe;

import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.subscribe.ClientLogicSubscriber;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import dev.architectury.platform.Platform;
import java.util.Optional;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;

public class ClientVRSubscriber {
    protected static int cooldown = 0;

    public static void immersiveTickVR(Player player) {
        if (Platform.getEnv() != Dist.CLIENT) {
            return;
        }
        if (Minecraft.m_91087_().f_91072_ == null) {
            return;
        }
        if (!VRPlugin.API.playerInVR(player)) {
            return;
        }
        VRPluginVerify.clientInVR = true;
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
        double dist = Minecraft.m_91087_().f_91072_.m_105286_();
        Vec3 start = vrPlayer.getHMD().position();
        Vec3 look = vrPlayer.getHMD().getLookAngle();
        Vec3 end = vrPlayer.getHMD().position().m_82520_(look.f_82479_ * dist, look.f_82480_ * dist, look.f_82481_ * dist);
        BlockHitResult res = player.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        ClientLogicSubscriber.possiblyTrack(res.m_82425_(), player.f_19853_.m_8055_(res.m_82425_()), player.f_19853_.m_7702_(res.m_82425_()), (Level)Minecraft.m_91087_().f_91073_);
        if (cooldown > 0) {
            --cooldown;
        } else {
            for (AbstractImmersive<? extends AbstractImmersiveInfo> singleton : Immersives.IMMERSIVES) {
                for (AbstractImmersiveInfo abstractImmersiveInfo : singleton.getTrackedObjects()) {
                    if (!ClientVRSubscriber.handleInfo(singleton, abstractImmersiveInfo, vrPlayer)) continue;
                    return;
                }
            }
        }
    }

    protected static boolean handleInfo(AbstractImmersive singleton, AbstractImmersiveInfo info, IVRPlayer vrPlayer) {
        if (info.hasHitboxes() && singleton.hitboxesAvailable(info)) {
            for (int c = 0; c <= 1; ++c) {
                IVRData controller = vrPlayer.getController(c);
                Vec3 pos = controller.position();
                Optional<Integer> hit = Util.getFirstIntersect(pos, info.getAllHitboxes());
                if (!hit.isPresent()) continue;
                singleton.onAnyRightClick(info);
                singleton.handleRightClick(info, (Player)Minecraft.m_91087_().f_91074_, hit.get(), c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                cooldown = Minecraft.m_91087_().f_91066_.f_92096_.m_90857_() ? 20 : singleton.getCooldownVR();
                return true;
            }
        }
        return false;
    }
}

