/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive;

import com.hammy275.immersivemc.common.compat.IronFurnaces;
import com.hammy275.immersivemc.common.immersive.CheckerFunction;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ImmersiveCheckers {
    public static final List<CheckerFunction<BlockPos, BlockState, BlockEntity, Level, Boolean>> CHECKERS = new LinkedList<CheckerFunction<BlockPos, BlockState, BlockEntity, Level, Boolean>>();

    public static boolean isAnvil(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return state.m_60734_() instanceof AnvilBlock || state.m_60734_() instanceof SmithingTableBlock;
    }

    public static boolean isBrewingStand(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return tileEntity instanceof BrewingStandBlockEntity;
    }

    public static boolean isChest(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return tileEntity instanceof ChestBlockEntity || tileEntity instanceof EnderChestBlockEntity;
    }

    public static boolean isCraftingTable(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return state.m_60734_() == Blocks.f_50091_ || tileEntity != null && tileEntity.getClass().getName().equals("slimeknights.tconstruct.tables.block.entity.table.CraftingStationBlockEntity");
    }

    public static boolean isEnchantingTable(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return state.m_60734_() instanceof EnchantmentTableBlock;
    }

    public static boolean isFurnace(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return tileEntity instanceof AbstractFurnaceBlockEntity || IronFurnaces.ironFurnaceTileBase.isInstance(tileEntity);
    }

    public static boolean isJukebox(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return tileEntity instanceof JukeboxBlockEntity;
    }

    public static boolean isRepeater(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return state.m_60734_() instanceof RepeaterBlock;
    }

    public static boolean isShulkerBox(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return tileEntity instanceof ShulkerBoxBlockEntity;
    }

    static {
        CHECKERS.add(ImmersiveCheckers::isAnvil);
        CHECKERS.add(ImmersiveCheckers::isBrewingStand);
        CHECKERS.add(ImmersiveCheckers::isChest);
        CHECKERS.add(ImmersiveCheckers::isCraftingTable);
        CHECKERS.add(ImmersiveCheckers::isEnchantingTable);
        CHECKERS.add(ImmersiveCheckers::isFurnace);
        CHECKERS.add(ImmersiveCheckers::isJukebox);
        CHECKERS.add(ImmersiveCheckers::isRepeater);
        CHECKERS.add(ImmersiveCheckers::isShulkerBox);
    }
}

