/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ChestToOpenCount;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;

public class ChestShulkerOpenPacket {
    public BlockPos pos;
    public boolean isOpen;

    public ChestShulkerOpenPacket(BlockPos pos, boolean isOpenPacket) {
        this.pos = pos;
        this.isOpen = isOpenPacket;
    }

    public static void encode(ChestShulkerOpenPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos).writeBoolean(packet.isOpen);
    }

    public static ChestShulkerOpenPacket decode(FriendlyByteBuf buffer) {
        return new ChestShulkerOpenPacket(buffer.m_130135_(), buffer.readBoolean());
    }

    public static void handle(ChestShulkerOpenPacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player != null && NetworkUtil.safeToRun(message.pos, player)) {
                BlockEntity tileEnt = player.f_19853_.m_7702_(message.pos);
                if (tileEnt instanceof ChestBlockEntity) {
                    if (!ActiveConfig.useChestImmersion) {
                        return;
                    }
                    ChestBlockEntity chest = (ChestBlockEntity)tileEnt;
                    ChestBlockEntity other = Util.getOtherChest(chest);
                    if (message.isOpen) {
                        chest.m_5856_((Player)player);
                        ChestShulkerOpenPacket.changeChestCount(chest.m_58899_(), 1);
                        if (other != null) {
                            other.m_5856_((Player)player);
                            ChestShulkerOpenPacket.changeChestCount(other.m_58899_(), 1);
                        }
                        PiglinAi.m_34873_((Player)player, (boolean)true);
                    } else {
                        chest.m_5785_((Player)player);
                        ChestShulkerOpenPacket.changeChestCount(chest.m_58899_(), -1);
                        if (other != null) {
                            other.m_5785_((Player)player);
                            ChestShulkerOpenPacket.changeChestCount(other.m_58899_(), -1);
                        }
                    }
                } else if (tileEnt instanceof EnderChestBlockEntity) {
                    if (!ActiveConfig.useChestImmersion) {
                        return;
                    }
                    EnderChestBlockEntity chest = (EnderChestBlockEntity)tileEnt;
                    if (message.isOpen) {
                        chest.m_155515_((Player)player);
                        ChestShulkerOpenPacket.changeChestCount(chest.m_58899_(), 1);
                        PiglinAi.m_34873_((Player)player, (boolean)true);
                    } else {
                        chest.m_155522_((Player)player);
                        ChestShulkerOpenPacket.changeChestCount(chest.m_58899_(), -1);
                    }
                } else if (tileEnt instanceof ShulkerBoxBlockEntity) {
                    ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)tileEnt;
                    if (!ActiveConfig.useShulkerImmersion) {
                        return;
                    }
                    if (message.isOpen) {
                        shulkerBox.m_5856_((Player)player);
                    } else {
                        shulkerBox.m_5785_((Player)player);
                    }
                }
            }
        });
    }

    protected static void changeChestCount(BlockPos pos, int amount) {
        Integer currentVal = ChestToOpenCount.chestImmersiveOpenCount.get(pos);
        int newVal = currentVal == null || currentVal == 0 ? amount : amount + currentVal;
        if (newVal <= 0) {
            ChestToOpenCount.chestImmersiveOpenCount.remove(pos);
        } else {
            ChestToOpenCount.chestImmersiveOpenCount.put(pos, newVal);
        }
    }
}

