/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.hammy275.immersivemc.server.storage.GetStorage;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class FetchPlayerStoragePacket {
    public final String storageKey;
    public final ImmersiveStorage storage;

    public FetchPlayerStoragePacket(String storageKey) {
        this.storageKey = storageKey;
        this.storage = null;
    }

    public FetchPlayerStoragePacket(ImmersiveStorage storage, String storageKey) {
        this.storage = storage;
        this.storageKey = storageKey;
    }

    public boolean isRequest() {
        return this.storage == null;
    }

    public static void encode(FetchPlayerStoragePacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.isRequest());
        if (packet.isRequest()) {
            buffer.m_130070_(packet.storageKey);
        } else {
            buffer.m_130079_(packet.storage.save(new CompoundTag()));
            buffer.m_130070_(packet.storageKey);
        }
    }

    public static FetchPlayerStoragePacket decode(FriendlyByteBuf buffer) {
        boolean isRequest = buffer.readBoolean();
        if (isRequest) {
            return new FetchPlayerStoragePacket(buffer.m_130277_());
        }
        CompoundTag storageTag = buffer.m_130260_();
        String storageType = buffer.m_130277_();
        return new FetchPlayerStoragePacket(GetStorage.assembleStorage(storageTag, "basic_item_store", null), storageType);
    }

    public static void handle(FetchPlayerStoragePacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player == null) {
                FetchPlayerStoragePacket.handleClient(message);
            } else {
                ImmersiveStorage storage = GetStorage.getPlayerStorage((Player)player, message.storageKey);
                Network.INSTANCE.sendToPlayer(player, (Object)new FetchPlayerStoragePacket(storage, message.storageKey));
            }
        });
    }

    public static void handleClient(FetchPlayerStoragePacket message) {
        if (message.storageKey.equals("backpack")) {
            Immersives.immersiveBackpack.processFromNetwork(message.storage);
        }
    }
}

