/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.client.immersive.AbstractWorldStorageImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractWorldStorageInfo;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.hammy275.immersivemc.server.storage.GetStorage;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class UpdateStoragePacket {
    public final BlockPos pos;
    public final ImmersiveStorage storage;
    public final String storageType;

    public UpdateStoragePacket(BlockPos pos, ImmersiveStorage storage, String storageType) {
        this.pos = pos;
        this.storage = storage;
        this.storageType = storageType;
    }

    public static void encode(UpdateStoragePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos).m_130079_(packet.storage.save(new CompoundTag())).m_130070_(packet.storageType);
    }

    public static UpdateStoragePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        CompoundTag nbt = buffer.m_130260_();
        String type = buffer.m_130277_();
        ImmersiveStorage storage = GetStorage.assembleStorage(nbt, type, null);
        return new UpdateStoragePacket(pos, storage, type);
    }

    public static void handle(UpdateStoragePacket message, Supplier<NetworkManager.PacketContext> ctx) {
        ctx.get().queue(() -> {
            ServerPlayer player;
            ServerPlayer serverPlayer = player = ((NetworkManager.PacketContext)ctx.get()).getPlayer() instanceof ServerPlayer ? (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer() : null;
            if (player == null) {
                for (AbstractWorldStorageImmersive<? extends AbstractWorldStorageInfo> immersive : Immersives.WS_IMMERSIVES) {
                    for (AbstractWorldStorageInfo info : immersive.getTrackedObjects()) {
                        if (!info.getBlockPosition().equals((Object)message.pos)) continue;
                        immersive.processStorageFromNetwork(info, message.storage);
                    }
                }
            }
        });
    }
}

