/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static void addStackToInventory(Player player, ItemStack item) {
        if (!item.m_41619_()) {
            player.m_150109_().m_36054_(item);
        }
    }

    public static boolean canPickUpItem(ItemEntity item, Player player) {
        return (!item.m_32063_() || player.m_150110_().f_35937_) && Math.abs(item.m_20184_().f_82479_) <= 0.01 && Math.abs(item.m_20184_().f_82481_) <= 0.01;
    }

    public static Optional<Integer> rayTraceClosest(Vec3 rayStart, Vec3 rayEnd, AABB ... targets) {
        double dist = Double.MAX_VALUE;
        Integer winner = null;
        int i = 0;
        for (AABB target : targets) {
            if (target != null) {
                double distTemp;
                if (target.m_82390_(rayStart)) {
                    return Optional.of(i);
                }
                Optional closestHitOpt = target.m_82371_(rayStart, rayEnd);
                double d = distTemp = closestHitOpt.isPresent() ? ((Vec3)closestHitOpt.get()).m_82554_(rayStart) : -1.0;
                if (closestHitOpt.isPresent() && distTemp < dist) {
                    winner = i;
                    dist = distTemp;
                }
            }
            ++i;
        }
        return Optional.ofNullable(winner);
    }

    public static Optional<Integer> getFirstIntersect(Vec3 pos, AABB ... targets) {
        int i = 0;
        for (AABB target : targets) {
            if (target != null && target.m_82390_(pos)) {
                return Optional.of(i);
            }
            ++i;
        }
        return Optional.empty();
    }

    public static Optional<Integer> getClosestIntersect(Vec3 pos, AABB[] targets, Vec3[] positions) {
        if (targets.length != positions.length) {
            throw new IllegalArgumentException("Targets and positions must be same length!");
        }
        int res = -1;
        double distanceToBeat = Double.MAX_VALUE;
        for (int i = 0; i < targets.length; ++i) {
            double newDist;
            if (targets[i] == null || !targets[i].m_82390_(pos) || !((newDist = pos.m_82557_(positions[i])) < distanceToBeat)) continue;
            distanceToBeat = newDist;
            res = i;
        }
        return res == -1 ? Optional.empty() : Optional.of(res);
    }

    public static ChestBlockEntity getOtherChest(ChestBlockEntity chest) {
        return Util.getOtherChest(chest, true);
    }

    protected static ChestBlockEntity getOtherChest(ChestBlockEntity chest, boolean checkOther) {
        Direction otherDir = ChestBlock.m_51584_((BlockState)chest.m_58900_());
        BlockPos otherPos = chest.m_58899_().m_121945_(otherDir);
        if (chest.m_58904_() != null && chest.m_58904_().m_7702_(otherPos) instanceof ChestBlockEntity) {
            ChestBlockEntity other = (ChestBlockEntity)chest.m_58904_().m_7702_(otherPos);
            if (checkOther && other != null) {
                return Util.getOtherChest(other, false) == chest ? other : null;
            }
            return other;
        }
        return null;
    }

    public static boolean stacksEqualBesidesCount(ItemStack a, ItemStack b) {
        int oldCountA = a.m_41613_();
        int oldCountB = b.m_41613_();
        a.m_41764_(1);
        b.m_41764_(1);
        boolean res = ItemStack.m_41728_((ItemStack)a, (ItemStack)b);
        a.m_41764_(oldCountA);
        b.m_41764_(oldCountB);
        return res;
    }

    public static ItemStackMergeResult mergeStacks(ItemStack mergeIntoIn, ItemStack mergeFromIn, boolean useCopy) {
        if (!Util.stacksEqualBesidesCount(mergeIntoIn, mergeFromIn) || mergeIntoIn.m_41741_() <= 1) {
            return new ItemStackMergeResult(mergeIntoIn, mergeFromIn);
        }
        ItemStack into = useCopy ? mergeIntoIn.m_41777_() : mergeIntoIn;
        ItemStack from = useCopy ? mergeFromIn.m_41777_() : mergeFromIn;
        int totalCount = into.m_41613_() + from.m_41613_();
        int fromAmount = 0;
        if (totalCount > into.m_41741_()) {
            fromAmount = totalCount - into.m_41741_();
            totalCount = into.m_41741_();
        }
        into.m_41764_(totalCount);
        from.m_41764_(fromAmount);
        return new ItemStackMergeResult(into, fromAmount == 0 ? ItemStack.f_41583_ : from);
    }

    public static void setRepeater(Level level, BlockPos pos, int newDelay) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof RepeaterBlock) {
            state = (BlockState)state.m_61124_((Property)RepeaterBlock.f_55798_, (Comparable)Integer.valueOf(newDelay));
            level.m_7731_(pos, state, 3);
        }
    }

    public static Vec3 getPlayerVelocity(Vec3 lastTickPos, Vec3 currentTickPos) {
        return new Vec3(currentTickPos.f_82479_ - lastTickPos.f_82479_, currentTickPos.f_82480_ - lastTickPos.f_82480_, currentTickPos.f_82481_ - lastTickPos.f_82481_);
    }

    public static double moveTowardsZero(double num, double subtract) {
        if ((subtract = Math.abs(subtract)) >= Math.abs(num)) {
            return 0.0;
        }
        if (num < 0.0) {
            return num + subtract;
        }
        return num - subtract;
    }

    public static class ItemStackMergeResult {
        public final ItemStack mergedInto;
        public final ItemStack mergedFrom;

        public ItemStackMergeResult(ItemStack mergedInto, ItemStack mergedFrom) {
            this.mergedInto = mergedInto;
            this.mergedFrom = mergedFrom;
        }

        public String toString() {
            return "Merged Into: " + this.mergedInto + "\nMerged From: " + this.mergedFrom;
        }
    }
}

