/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.vr.mixin_proxy;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;

public class LivingEntityMixinProxy {
    private static boolean isImmersiveBlocking(LivingEntity living) {
        if (living instanceof Player) {
            Player player = (Player)living;
            if (ActiveConfig.immersiveShield && VRPlugin.API.playerInVR(player) && player.m_21211_().m_41619_()) {
                for (InteractionHand iHand : InteractionHand.values()) {
                    if (player.m_21120_(iHand).m_41780_() != UseAnim.BLOCK) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Boolean isDamageSourceBlocked(LivingEntity living, DamageSource damageSource) {
        if (living instanceof Player) {
            Player player = (Player)living;
            if (ActiveConfig.immersiveShield && VRPlugin.API.playerInVR(player) && LivingEntityMixinProxy.isImmersiveBlocking((LivingEntity)player)) {
                AbstractArrow arrow;
                InteractionHand[] interactionHandArray = damageSource.m_7640_();
                if (interactionHandArray instanceof AbstractArrow && (arrow = (AbstractArrow)interactionHandArray).m_36796_() > 0) {
                    return false;
                }
                if (!damageSource.m_19376_() && damageSource.m_7270_() != null) {
                    IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
                    for (InteractionHand iHand : InteractionHand.values()) {
                        Vec3 attackerVec;
                        if (player.m_21120_(iHand).m_41780_() != UseAnim.BLOCK) continue;
                        IVRData hand = vrPlayer.getController(iHand.ordinal());
                        float toRot = (float)(iHand == InteractionHand.MAIN_HAND ? -1.5707963267948966 : 1.5707963267948966);
                        Vec3 handVec = hand.getLookAngle().m_82524_(toRot).m_82541_();
                        double angle = Math.acos(handVec.m_82526_(attackerVec = damageSource.m_7270_().m_82505_(player.m_20182_()).m_82541_()));
                        if (!(angle <= Math.PI) || !(angle >= 2.0943951023931953)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return null;
    }
}

