/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.storage;

import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.hammy275.immersivemc.server.storage.GetStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;

public class ImmersiveMCLevelStorage
extends SavedData {
    protected Map<BlockPos, ImmersiveStorage> itemInfo = new HashMap<BlockPos, ImmersiveStorage>();

    private static ImmersiveMCLevelStorage create() {
        return new ImmersiveMCLevelStorage();
    }

    public static boolean usesWorldStorage(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isCraftingTable(pos, state, tileEntity, level) || ImmersiveCheckers.isAnvil(pos, state, tileEntity, level) || ImmersiveCheckers.isEnchantingTable(pos, state, tileEntity, level);
    }

    public static ImmersiveMCLevelStorage getLevelStorage(ServerLevel world) {
        return (ImmersiveMCLevelStorage)world.m_8895_().m_164861_(ImmersiveMCLevelStorage::load, ImmersiveMCLevelStorage::create, "immersivemc_data");
    }

    public static ImmersiveMCLevelStorage getLevelStorage(Player player) {
        if (player instanceof ServerPlayer) {
            return ImmersiveMCLevelStorage.getLevelStorage((ServerLevel)player.f_19853_);
        }
        throw new IllegalArgumentException("Can only get storage server side!");
    }

    public ImmersiveStorage getOrCreate(BlockPos pos) {
        ImmersiveStorage storage = this.get(pos);
        if (storage == null) {
            storage = new ImmersiveStorage(this);
            this.add(pos, storage);
        }
        return storage;
    }

    public ImmersiveStorage remove(BlockPos pos) {
        ImmersiveStorage storage = this.itemInfo.remove(pos);
        this.m_77762_();
        return storage;
    }

    public void add(BlockPos pos, ImmersiveStorage storage) {
        this.itemInfo.put(pos, storage);
        this.m_77762_();
    }

    public ImmersiveStorage get(BlockPos pos) {
        return this.itemInfo.get(pos);
    }

    public static ImmersiveMCLevelStorage load(CompoundTag nbt) {
        ImmersiveMCLevelStorage levelStorage = new ImmersiveMCLevelStorage();
        Map<BlockPos, ImmersiveStorage> itemInfo = levelStorage.itemInfo;
        itemInfo.clear();
        int numOfStorages = nbt.m_128451_("numOfStorages");
        CompoundTag storages = nbt.m_128469_("storages");
        for (int i = 0; i < numOfStorages; ++i) {
            CompoundTag storageInfo = storages.m_128469_(String.valueOf(i));
            BlockPos pos = new BlockPos(storageInfo.m_128451_("posX"), storageInfo.m_128451_("posY"), storageInfo.m_128451_("posZ"));
            String storageType = storageInfo.m_128461_("dataType");
            ImmersiveStorage storage = GetStorage.assembleStorage(storageInfo.m_128469_("data"), storageType, levelStorage);
            itemInfo.put(pos, storage);
        }
        return levelStorage;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128405_("numOfStorages", this.itemInfo.size());
        CompoundTag storages = new CompoundTag();
        int i = 0;
        for (Map.Entry<BlockPos, ImmersiveStorage> entry : this.itemInfo.entrySet()) {
            CompoundTag storageInfo = new CompoundTag();
            storageInfo.m_128405_("posX", entry.getKey().m_123341_());
            storageInfo.m_128405_("posY", entry.getKey().m_123342_());
            storageInfo.m_128405_("posZ", entry.getKey().m_123343_());
            storageInfo.m_128365_("data", (Tag)entry.getValue().save(new CompoundTag()));
            storageInfo.m_128359_("dataType", entry.getValue().getType());
            storages.m_128365_(String.valueOf(i), (Tag)storageInfo);
            ++i;
        }
        nbt.m_128365_("storages", (Tag)storages);
        return nbt;
    }
}

