/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.PlayerConfigs;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LeverTracker
extends AbstractTracker {
    public static Map<String, LeverInfo> infos = new HashMap<String, LeverInfo>();

    public LeverTracker() {
        ServerTrackerInit.playerTrackers.add(this);
    }

    @Override
    protected void tick(Player player) {
        LeverInfo info = infos.get(player.m_36316_().getName());
        if (info == null) {
            info = new LeverInfo();
            infos.put(player.m_36316_().getName(), info);
        }
        info.tick();
        if (info.cooldown > 0) {
            return;
        }
        for (int c = 0; c <= 1; ++c) {
            Vec3 last;
            Vec3 hitboxPos;
            BlockPos leverPos;
            BlockState state;
            Vec3 handPos = VRPlugin.API.getVRPlayer(player).getController(c).position();
            BlockPos handBlockPos = new BlockPos(handPos);
            if (player.f_19853_.m_8055_(handBlockPos).m_60734_() == Blocks.f_50164_) {
                state = player.f_19853_.m_8055_(handBlockPos);
                leverPos = handBlockPos;
            } else if (player.f_19853_.m_8055_(handBlockPos.m_7495_()).m_60734_() == Blocks.f_50164_) {
                state = player.f_19853_.m_8055_(handBlockPos.m_7495_());
                leverPos = handBlockPos.m_7495_();
            } else {
                if (player.f_19853_.m_8055_(handBlockPos.m_7494_()).m_60734_() != Blocks.f_50164_) continue;
                state = player.f_19853_.m_8055_(handBlockPos.m_7494_());
                leverPos = handBlockPos.m_7494_();
            }
            if (state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) == AttachFace.WALL) {
                hitboxPos = Vec3.m_82512_((Vec3i)leverPos);
                Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                Direction towardsWall = facing.m_122424_();
                unit = Vec3.m_82528_((Vec3i)towardsWall.m_122436_());
                hitboxPos = hitboxPos.m_82549_(unit.m_82542_(0.25, 0.25, 0.25));
                hitboxPos = ((Boolean)state.m_61143_((Property)LeverBlock.f_54622_)).booleanValue() ? hitboxPos.m_82520_(0.0, -0.3333333333333333, 0.0) : hitboxPos.m_82520_(0.0, 0.3333333333333333, 0.0);
            } else {
                hitboxPos = Vec3.m_82512_((Vec3i)leverPos);
                Direction facingOn = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                Direction facingOff = facingOn.m_122424_();
                unit = (Boolean)state.m_61143_((Property)LeverBlock.f_54622_) != false ? Vec3.m_82528_((Vec3i)facingOn.m_122436_()) : Vec3.m_82528_((Vec3i)facingOff.m_122436_());
                hitboxPos = hitboxPos.m_82549_(unit.m_82542_(0.25, 0.25, 0.25));
            }
            double size = 0.25;
            AABB hitbox = new AABB(hitboxPos.f_82479_ - size, hitboxPos.f_82480_ - size, hitboxPos.f_82481_ - size, hitboxPos.f_82479_ + size, hitboxPos.f_82480_ + size, hitboxPos.f_82481_ + size);
            if (hitbox.m_82390_(handPos) && (last = info.getLastPos(c)).m_82557_(handPos) > 0.010000000000000002) {
                info.cooldown = 20;
                LeverBlock leverBlock = (LeverBlock)Blocks.f_50164_;
                leverBlock.m_6227_(state, player.f_19853_, leverPos, player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, null);
            }
            info.setLastPos(c, handPos);
        }
    }

    @Override
    protected boolean shouldTick(Player player) {
        return ActiveConfig.useLever && VRPluginVerify.hasAPI && VRPlugin.API.playerInVR(player) && PlayerConfigs.getConfig((Player)player).useLevers;
    }

    public static class LeverInfo {
        public int cooldown = 0;
        public Vec3 lastPosMain = Vec3.f_82478_;
        public Vec3 lastPosOff = Vec3.f_82478_;

        public void tick() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }

        public Vec3 getLastPos(int c) {
            return c == 0 ? this.lastPosMain : this.lastPosOff;
        }

        public void setLastPos(int c, Vec3 pos) {
            if (c == 0) {
                this.lastPosMain = pos;
            } else {
                this.lastPosOff = pos;
            }
        }
    }
}

