/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ServerPlayerConfig;
import com.hammy275.immersivemc.server.LastTickVRData;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import java.util.HashMap;
import java.util.Map;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DoorMoveTracker
extends AbstractVRHandTracker {
    public static final double THRESHOLD = 0.06;
    public Map<String, Integer> cooldown = new HashMap<String, Integer>();

    @Override
    public void preTick(Player player) {
        super.preTick(player);
        int newCooldown = this.cooldown.getOrDefault(player.m_36316_().getName(), 0) - 1;
        if (newCooldown <= 0) {
            this.cooldown.remove(player.m_36316_().getName());
        } else {
            this.cooldown.put(player.m_36316_().getName(), newCooldown);
        }
    }

    @Override
    protected boolean shouldRunForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        Block block = this.getBlockAtHand(player, currentVRData, hand);
        return this.cooldown.get(player.m_36316_().getName()) == null && (block instanceof FenceGateBlock || block instanceof DoorBlock);
    }

    @Override
    protected void runForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        boolean otherMoveCheck;
        BlockState blockState = this.getBlockStateAtHand(player, currentVRData, hand);
        Vec3 velocity = LastTickVRData.getVelocity(lastVRData.lastPlayer.getController(hand.ordinal()), currentVRData.getController(hand.ordinal()), lastVRData);
        Direction pushPullMainDirection = DoorMoveTracker.getDirectionToMove(blockState);
        boolean bl = otherMoveCheck = blockState.m_60734_() instanceof FenceGateBlock && this.movingInDirectionWithThreshold(pushPullMainDirection.m_122424_(), velocity, 0.06);
        if (this.movingInDirectionWithThreshold(pushPullMainDirection, velocity, 0.06) || otherMoveCheck) {
            blockState.m_60664_(player.f_19853_, player, InteractionHand.MAIN_HAND, new BlockHitResult(currentVRData.getController(hand.ordinal()).position(), pushPullMainDirection, this.getBlockPosAtHand(currentVRData, hand), false));
            this.cooldown.put(player.m_36316_().getName(), 10);
        }
    }

    @Override
    public boolean isEnabledInConfig(ServerPlayerConfig config) {
        return config.useDoorImmersion;
    }

    public static Direction getDirectionToMove(BlockState state) {
        boolean isOpen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        return isOpen ? ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122427_() : (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
    }
}

