/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.integration;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.anti_ad.mc.common.TellPlayer;
import org.anti_ad.mc.common.extensions.Java_ioKt;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.integration.ButtonPositionHint;
import org.anti_ad.mc.ipnext.integration.HintClassData;
import org.anti_ad.mc.ipnext.integration.HintClassData$$serializer;
import org.anti_ad.mc.ipnext.integration.HintsManagerNG$doInit$2;
import org.anti_ad.mc.ipnext.integration.HintsManagerNGKt;
import org.anti_ad.mc.ipnext.integration.MergePriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nHintsManagerNG.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HintsManagerNG.kt\norg/anti_ad/mc/ipnext/integration/HintsManagerNG\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 common.kt\norg/anti_ad/mc/common/extensions/CommonKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 HintsManagerNG.kt\norg/anti_ad/mc/ipnext/integration/HintsManagerNGKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,334:1\n80#2:335\n80#2:348\n42#2:367\n42#2:392\n33#3:336\n89#3,4:337\n34#3:341\n33#3:349\n89#3,4:350\n34#3:354\n33#3:371\n89#3,4:372\n34#3:376\n33#3:377\n89#3,4:378\n34#3:382\n215#4,2:342\n215#4,2:344\n215#4:355\n215#4:356\n216#4:358\n216#4:359\n215#4,2:362\n215#4,2:364\n215#4:366\n216#4:368\n215#4,2:390\n317#5,2:346\n319#5,2:360\n1#6:357\n13579#7,2:369\n483#8,7:383\n*S KotlinDebug\n*F\n+ 1 HintsManagerNG.kt\norg/anti_ad/mc/ipnext/integration/HintsManagerNG\n*L\n78#1:335\n131#1:348\n180#1:367\n305#1:392\n79#1:336\n79#1:337,4\n79#1:341\n133#1:349\n133#1:350,4\n133#1:354\n252#1:371\n252#1:372,4\n252#1:376\n259#1:377\n259#1:378,4\n259#1:382\n119#1:342,2\n123#1:344,2\n135#1:355\n136#1:356\n136#1:358\n135#1:359\n159#1:362,2\n164#1:364,2\n175#1:366\n175#1:368\n274#1:390,2\n130#1:346,2\n130#1:360,2\n202#1:369,2\n272#1:383,7\n*E\n"})
public final class HintsManagerNG {
    @NotNull
    public static final HintsManagerNG INSTANCE = new HintsManagerNG();
    @NotNull
    private static final String exampleFileName = "exampleIntegrationHints.json";
    @NotNull
    private static final String builtInHintsResource = "assets/inventoryprofilesnext/config/ModIntegrationHintsNG.json";
    @NotNull
    private static final String hintsExport = "ModIntegrationExport.json";
    @NotNull
    private static final String exampleHintsResource = "assets/inventoryprofilesnext/config/exampleIntegrationHints.json";
    @NotNull
    private static final String integratedOverride = "ModIntegrationOverride.json";
    private static Path externalHintsPath;
    private static Path configRoot;
    @NotNull
    private static final Map externalConfigs;
    @NotNull
    private static final Map internalConfigs;
    @NotNull
    private static final Map effectiveHints;

    private HintsManagerNG() {
    }

    private final Map processConfig(InputStream inputStream) {
        Json json2 = HintsManagerNGKt.access$getJson$p();
        json2.getSerializersModule();
        Object object = JvmStreamsKt.decodeFromStream((Json)json2, (DeserializationStrategy)((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)HintClassData$$serializer.INSTANCE)), (InputStream)inputStream);
        try {
            inputStream.close();
        }
        catch (Throwable throwable) {}
        return (Map)object;
    }

    public final void init(@NotNull Path path2, @NotNull Path path3) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"");
        Intrinsics.checkNotNullParameter((Object)path3, (String)"");
        this.reset();
        configRoot = path2;
        externalHintsPath = path3;
        this.doInit();
    }

    private final void doInit() {
        Iterator iterator;
        Path path2;
        Path path3;
        Object object;
        Path object22;
        Path path4 = externalHintsPath;
        if (path4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            path4 = null;
        }
        if (Files.isDirectory(object22 = path4, Arrays.copyOf(object = new LinkOption[0], 0))) {
            Path path5 = externalHintsPath;
            if (path5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"");
                path5 = null;
            }
            FileVisitOption[] fileVisitOptionArray = new FileVisitOption[1];
            FileVisitOption[] fileVisitOptionArray2 = fileVisitOptionArray;
            fileVisitOptionArray[0] = FileVisitOption.FOLLOW_LINKS;
            Files.find(path5, 1, HintsManagerNG::doInit$lambda$2, fileVisitOptionArray2).forEach(arg_0 -> HintsManagerNG.doInit$lambda$3(HintsManagerNG$doInit$2.INSTANCE, arg_0));
        }
        if ((path3 = configRoot) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            path3 = null;
        }
        if (Java_ioKt.exists((Path)(path2 = Java_ioKt.div((Path)path3, (String)integratedOverride)))) {
            InputStream inputStream = Files.newInputStream(path2, Arrays.copyOf(new OpenOption[0], 0));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"");
            object = inputStream;
            Throwable throwable = null;
            try {
                iterator = (InputStream)object;
                INSTANCE.readInternalConfig((InputStream)((Object)iterator));
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                Throwable throwable4 = throwable2;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        InputStream inputStream = HintsManagerNG.class.getClassLoader().getResourceAsStream(builtInHintsResource);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            iterator = null;
            try {
                object = (InputStream)closeable;
                INSTANCE.readInternalConfig((InputStream)object);
            }
            catch (Throwable throwable) {
                object = throwable;
                iterator = throwable;
                throw object;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)((Object)iterator));
            }
        }
        Log.INSTANCE.info("Loaded " + externalConfigs.size() + " external GUI hints");
        for (Map.Entry entry : externalConfigs.entrySet()) {
            object = (String)entry.getKey();
            HintClassData hintClassData = (HintClassData)entry.getValue();
            effectiveHints.putIfAbsent(object, hintClassData);
        }
        Log.INSTANCE.info("Loaded " + internalConfigs.size() + " build-in GUI hints");
        for (Map.Entry entry : internalConfigs.entrySet()) {
            object = (String)entry.getKey();
            HintClassData hintClassData = (HintClassData)entry.getValue();
            effectiveHints.putIfAbsent(object, hintClassData);
        }
        Log.INSTANCE.info("Effective GUI hints after merge: " + effectiveHints.size());
    }

    private final void readInternalConfig(InputStream object) {
        String string = "";
        try {
            Json json2 = HintsManagerNGKt.access$getJson$p();
            json2.getSerializersModule();
            Object object22 = JvmStreamsKt.decodeFromStream((Json)json2, (DeserializationStrategy)((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)HintClassData$$serializer.INSTANCE))), (InputStream)((Object)object));
            try {
                ((InputStream)((Object)object)).close();
            }
            catch (Throwable throwable) {}
            for (Map.Entry entry : ((Map)object22).entrySet()) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    Map map = internalConfigs;
                    Object k2 = entry2.getKey();
                    entry2 = entry2.getValue();
                    ((HintClassData)((Object)entry2)).changeId((String)entry.getKey());
                    map.put(k2, entry2);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            HintsManagerNGKt.access$logError(throwable, string);
            return;
        }
    }

    public final void saveAllAsIntegrated(@NotNull MergePriority object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = MapsKt.toSortedMap((Map)this.collectAllWithPriority((MergePriority)((Object)object)));
        Path path2 = configRoot;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            path2 = null;
        }
        Object object2 = Java_ioKt.div((Path)path2, (String)hintsExport);
        Files.deleteIfExists((Path)object2);
        OutputStream outputStream = Files.newOutputStream((Path)object2, Arrays.copyOf(new OpenOption[0], 0));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"");
        object2 = outputStream;
        JvmStreamsKt.encodeToStream((Json)HintsManagerNGKt.access$getJson$p(), (SerializationStrategy)((SerializationStrategy)BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)HintClassData.Companion.serializer()))), (Object)object, (OutputStream)object2);
        ((OutputStream)object2).close();
    }

    private final Map collectAllWithPriority(MergePriority object) {
        String string;
        Iterator iterator = object == MergePriority.EXTERNAL ? externalConfigs : internalConfigs;
        object = object == MergePriority.EXTERNAL ? internalConfigs : externalConfigs;
        Map map = new LinkedHashMap();
        Set set = new LinkedHashSet();
        for (Map.Entry entry : iterator.entrySet()) {
            string = (String)entry.getKey();
            HintClassData object2 = (HintClassData)entry.getValue();
            String string2 = object2.readId();
            Intrinsics.checkNotNull((Object)string2);
            Map map2 = map.putIfAbsent(string2, (Map)new LinkedHashMap());
            if (map2 == null) {
                String string3 = object2.readId();
                Intrinsics.checkNotNull((Object)string3);
                map2 = (Map)map.get(string3);
            }
            Intrinsics.checkNotNull((Object)map2);
            map2.putIfAbsent(string, HintClassData.copy$default(object2, false, false, false, object2.copyOnlyChanged(), false, 23, null));
            set.add(string);
        }
        for (Map.Entry entry : object.entrySet()) {
            string = (String)entry.getKey();
            HintClassData hintClassData = (HintClassData)entry.getValue();
            if (set.contains(string)) continue;
            String string4 = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string4);
            Map map3 = map.putIfAbsent(string4, (Map)new LinkedHashMap());
            if (map3 == null) {
                String string5 = hintClassData.readId();
                Intrinsics.checkNotNull((Object)string5);
                map3 = (Map)map.get(string5);
            }
            Intrinsics.checkNotNull((Object)map3);
            map3.putIfAbsent(string, HintClassData.copy$default(hintClassData, false, false, false, hintClassData.copyOnlyChanged(), false, 23, null));
        }
        return map;
    }

    public final void saveAllAsSeparate(@NotNull MergePriority object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        for (Map.Entry entry : this.collectAllWithPriority((MergePriority)((Object)object)).entrySet()) {
            OutputStream outputStream;
            Object object2 = (String)entry.getKey();
            Map object22 = (Map)entry.getValue();
            Path path2 = externalHintsPath;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"");
                path2 = null;
            }
            object2 = Java_ioKt.div((Path)path2, (String)((String)object2 + ".json"));
            Files.deleteIfExists((Path)object2);
            Intrinsics.checkNotNullExpressionValue((Object)Files.newOutputStream((Path)object2, Arrays.copyOf(new OpenOption[0], 0)), (String)"");
            TellPlayer.INSTANCE.chat("Generating " + PathsKt.getName((Path)object2));
            Json json2 = HintsManagerNGKt.access$getJson$p();
            json2.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)json2, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)HintClassData$$serializer.INSTANCE)), (Object)object22, (OutputStream)outputStream);
        }
    }

    @NotNull
    public final HintClassData getHints(@NotNull Class clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
        Object object = (HintClassData)effectiveHints.get(clazz.getName());
        Object object2 = object != null && !((HintClassData)object).getForce() && (clazz.isAnnotationPresent(IPNIgnore.class) || clazz.isAnnotationPresent(IPNPlayerSideOnly.class) || clazz.isAnnotationPresent(IPNGuiHint.class)) ? null : object;
        if (object2 == null) {
            Object[] objectArray;
            Object[] objectArray2;
            object = INSTANCE;
            Object[] objectArray3 = ((HintsManagerNG)object).getIgnoredClass(clazz);
            if (objectArray3 != null) {
                objectArray2 = objectArray3;
                Object[] objectArray4 = objectArray3;
                if (!Intrinsics.areEqual((Object)objectArray3, (Object)clazz)) {
                    ((HintsManagerNG)object).getHints((Class)objectArray4);
                }
                objectArray = objectArray2;
            } else {
                objectArray = null;
            }
            boolean bl = objectArray != null;
            Map map = new LinkedHashMap();
            Annotation[] annotationArray = clazz.getAnnotationsByType(IPNGuiHint.class);
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"");
            objectArray2 = annotationArray;
            int n2 = objectArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                IPNGuiHint iPNGuiHint = (IPNGuiHint)objectArray2[i2];
                map.put(iPNGuiHint.button(), new ButtonPositionHint(iPNGuiHint.horizontalOffset(), iPNGuiHint.top(), iPNGuiHint.bottom(), iPNGuiHint.hide()));
            }
            boolean bl2 = clazz.isAnnotationPresent(IPNPlayerSideOnly.class);
            Object object3 = bl || bl2 || !map.isEmpty() ? new HintClassData(bl, bl2, false, map, false) : new HintClassData(false, false, false, null, false, 31, null);
            ((HintClassData)object3).fillMissingHints();
            HintClassData hintClassData = object3;
            object3 = effectiveHints;
            String string = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            object3.put(string, hintClassData);
            object2 = hintClassData;
        }
        return object2;
    }

    private final Class getIgnoredClass(Class clazz) {
        while (!Intrinsics.areEqual((Object)clazz, Object.class)) {
            if (clazz.isAnnotationPresent(IPNIgnore.class)) {
                return clazz;
            }
            Intrinsics.checkNotNullExpressionValue(clazz.getSuperclass(), (String)"");
        }
        return null;
    }

    private final void reset() {
        externalConfigs.clear();
        internalConfigs.clear();
        effectiveHints.clear();
    }

    public final boolean isPlayerSideOnly(@Nullable Class clazz) {
        return clazz != null && this.getHints(clazz).getPlayerSideOnly();
    }

    public final boolean isFastSwipeDisabled(@Nullable Class clazz) {
        return clazz != null && this.getHints(clazz).getDisableFastSwipe();
    }

    public final void upgradeOldConfig(@NotNull Path object, @NotNull Path object2) {
        Object object3;
        Object object4;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        if (Java_ioKt.exists((Path)object)) {
            try {
                object4 = object;
                object3 = Java_ioKt.div((Path)object2, (String)"upgraded-From-Pre-v1.2.5.json");
                object = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.move((Path)object4, (Path)object3, Arrays.copyOf(object, 0)), (String)"");
            }
            catch (Throwable throwable) {}
        }
        if (Files.notExists((Path)(object = Java_ioKt.div((Path)object2, (String)exampleFileName)), Arrays.copyOf(new LinkOption[0], 0))) {
            InputStream inputStream = HintsManagerNG.class.getClassLoader().getResourceAsStream(exampleHintsResource);
            if (inputStream != null) {
                object2 = inputStream;
                object4 = null;
                try {
                    object3 = (InputStream)object2;
                    try {
                        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(new OpenOption[0], 0));
                        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"");
                        object = outputStream;
                        Throwable throwable = null;
                        try {
                            OutputStream outputStream2 = (OutputStream)object;
                            ByteStreamsKt.copyTo$default((InputStream)object3, (OutputStream)outputStream2, (int)0, (int)2, null);
                            outputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                        ((InputStream)object3).close();
                    }
                    catch (Throwable throwable) {}
                    return;
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    object4 = throwable;
                    throw object3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object4);
                }
            }
        }
    }

    private final Map getAllById(String object) {
        Map map;
        Map map2 = map = (Map)new LinkedHashMap();
        Map map3 = effectiveHints;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : map3.entrySet()) {
            HintClassData hintClassData = (HintClassData)entry.getValue();
            if (!Intrinsics.areEqual((Object)object, (Object)hintClassData.readId())) continue;
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : ((Map)linkedHashMap).entrySet()) {
            if (!((HintClassData)entry.getValue()).hasInfo()) continue;
            object = ((HintClassData)entry.getValue()).copyOnlyChanged();
            map2.put(entry.getKey(), HintClassData.copy$default((HintClassData)entry.getValue(), false, false, false, (Map)object, false, 23, null));
        }
        return map;
    }

    public final void saveDirty(@NotNull HintClassData hintClassData, @NotNull HintClassData hintClassData2) {
        Intrinsics.checkNotNullParameter((Object)hintClassData, (String)"");
        Intrinsics.checkNotNullParameter((Object)hintClassData2, (String)"");
        if (Intrinsics.areEqual((Object)hintClassData.readId(), (Object)hintClassData2.readId())) {
            String string = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string);
            String string2 = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string2);
            this.saveFile(string, this.getAllById(string2));
        } else {
            String string = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string);
            String string3 = hintClassData.readId();
            Intrinsics.checkNotNull((Object)string3);
            this.saveFile(string, this.getAllById(string3));
            String string4 = hintClassData2.readId();
            Intrinsics.checkNotNull((Object)string4);
            String string5 = hintClassData2.readId();
            Intrinsics.checkNotNull((Object)string5);
            this.saveFile(string4, this.getAllById(string5));
        }
        this.reset();
        this.doInit();
    }

    private final void saveFile(String object, Map map) {
        String string = ((String)object).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        object = !StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null) ? (String)object + ".json" : object;
        Path path2 = externalHintsPath;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            path2 = null;
        }
        object = Java_ioKt.div((Path)path2, (String)object);
        Files.deleteIfExists((Path)object);
        if (!map.isEmpty()) {
            Json json2 = HintsManagerNGKt.access$getJson$p();
            OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(new OpenOption[0], 0));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"");
            object = outputStream;
            Json json3 = json2;
            json3.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)json3, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)HintClassData$$serializer.INSTANCE)), (Object)map, (OutputStream)object);
        }
    }

    private static final boolean doInit$lambda$2(Path path2, BasicFileAttributes basicFileAttributes) {
        return basicFileAttributes.isRegularFile() && StringsKt.endsWith$default((String)((Object)path2.getFileName()).toString(), (String)".json", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)((Object)path2.getFileName()).toString(), (Object)exampleFileName);
    }

    private static final void doInit$lambda$3(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        function1.invoke(object);
    }

    public static final /* synthetic */ Map access$getExternalConfigs$p() {
        return externalConfigs;
    }

    public static final /* synthetic */ Map access$processConfig(HintsManagerNG hintsManagerNG, InputStream inputStream) {
        return hintsManagerNG.processConfig(inputStream);
    }

    static {
        externalConfigs = new LinkedHashMap();
        internalConfigs = new LinkedHashMap();
        effectiveHints = new LinkedHashMap();
    }
}

