/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.event;

import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.input.MainKeybind;
import org.anti_ad.mc.common.moreinfo.InfoManagerBase;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.ipnext.IPNInfoManager;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.config.GuiSettings;
import org.anti_ad.mc.ipnext.config.ModSettings;
import org.anti_ad.mc.ipnext.event.ContinuousCraftingHandler$IMonitor;
import org.anti_ad.mc.ipnext.event.ContinuousCraftingHandler$Monitor;
import org.anti_ad.mc.ipnext.event.ContinuousCraftingHandler$MonitorP;
import org.anti_ad.mc.ipnext.inventory.ContainerClicker;
import org.anti_ad.mc.ipnext.inventory.ContainerType;
import org.anti_ad.mc.ipnext.inventory.ContainerTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContinuousCraftingHandler {
    @NotNull
    public static final ContinuousCraftingHandler INSTANCE = new ContinuousCraftingHandler();
    private static boolean afterRefill;
    private static int autoRefillRetry;
    private static int submitNextCraft;
    private static boolean processingClick;
    @Nullable
    private static AbstractContainerScreen trackingScreen;
    private static ContinuousCraftingHandler$IMonitor monitor;
    private static boolean isCrafting;
    private static int onCraftCount;
    private static boolean crafted;
    @NotNull
    private static final MainKeybind SHIFT;

    private ContinuousCraftingHandler() {
    }

    public final boolean getProcessingClick() {
        return processingClick;
    }

    public final void setProcessingClick(boolean bl) {
        processingClick = bl;
    }

    private final boolean getEnabled() {
        return GuiSettings.INSTANCE.getCONTINUOUS_CRAFTING_SAVED_VALUE().getBooleanValue();
    }

    public final void onTickInGame() {
        Screen screen = Vanilla.INSTANCE.screen();
        if (this.getEnabled() && screen instanceof AbstractContainerScreen) {
            if (!Intrinsics.areEqual((Object)screen, (Object)trackingScreen)) {
                trackingScreen = (AbstractContainerScreen)screen;
                this.init();
            }
            this.handle();
        }
    }

    private final void init() {
        AbstractContainerMenu abstractContainerMenu = Vanilla.INSTANCE.container();
        isCrafting = ContainerTypes.INSTANCE.getTypes(abstractContainerMenu).contains((Object)ContainerType.CRAFTING);
        if (!isCrafting) {
            return;
        }
        monitor = switch (ModSettings.INSTANCE.getCONTINUOUS_CRAFTING_METHOD().getIntegerValue()) {
            case 1 -> {
                Log.INSTANCE.trace("Using DEFAULT Monitor");
                yield new ContinuousCraftingHandler$Monitor(abstractContainerMenu);
            }
            case 2 -> {
                Log.INSTANCE.trace("Using OLD Monitor");
                yield new ContinuousCraftingHandler$MonitorP(abstractContainerMenu);
            }
            default -> {
                Log.INSTANCE.error("Unexpected value so Using DEFAULT Monitor");
                yield new ContinuousCraftingHandler$Monitor(abstractContainerMenu);
            }
        };
        onCraftCount = 0;
        crafted = false;
        processingClick = false;
    }

    private final void handle() {
        if (!isCrafting) {
            return;
        }
        if (!processingClick && onCraftCount > 0) {
            onCraftCount += -1;
        }
        if (submitNextCraft > 0 && (submitNextCraft += -1) <= 0) {
            Vanilla.INSTANCE.queueForMainThread(ContinuousCraftingHandler::handle$lambda$0);
            submitNextCraft = 0;
        }
        if (afterRefill) {
            if (SHIFT.isPressing() && ModSettings.INSTANCE.getINCLUDE_HOTBAR_MODIFIER().isPressing()) {
                InfoManagerBase.event$default((InfoManagerBase)IPNInfoManager.INSTANCE, (String)"auto-crafting", null, (int)2, null);
                submitNextCraft = ModSettings.INSTANCE.getAUTO_CRAFT_DELAY().getIntegerValue();
            }
            afterRefill = false;
        }
        if (crafted) {
            if (!processingClick && onCraftCount <= 0) {
                ContinuousCraftingHandler$IMonitor continuousCraftingHandler$IMonitor = monitor;
                if (continuousCraftingHandler$IMonitor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"");
                    continuousCraftingHandler$IMonitor = null;
                }
                if (continuousCraftingHandler$IMonitor.autoRefill()) {
                    InfoManagerBase.event$default((InfoManagerBase)IPNInfoManager.INSTANCE, (String)"cont-crafting", null, (int)2, null);
                    crafted = false;
                    onCraftCount = 0;
                    afterRefill = true;
                    autoRefillRetry = 0;
                } else if (autoRefillRetry < 6) {
                    ++autoRefillRetry;
                } else {
                    autoRefillRetry = 0;
                    crafted = false;
                    onCraftCount = 0;
                    afterRefill = false;
                }
            } else {
                Log.INSTANCE.trace("Not refilling yet");
            }
        }
        if (!crafted) {
            ContinuousCraftingHandler$IMonitor continuousCraftingHandler$IMonitor = monitor;
            if (continuousCraftingHandler$IMonitor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"");
                continuousCraftingHandler$IMonitor = null;
            }
            continuousCraftingHandler$IMonitor.save();
        }
    }

    public final void onCrafted() {
        if (!isCrafting) {
            return;
        }
        onCraftCount = RangesKt.coerceAtMost((int)(onCraftCount + 2), (int)2);
        crafted = true;
        Log.INSTANCE.trace("crafted!!!!!!");
    }

    private static final void handle$lambda$0() {
        ContainerClicker.INSTANCE.shiftClick(0);
    }

    static {
        SHIFT = new MainKeybind("LEFT_SHIFT", KeybindSettings.Companion.getGUI_EXTRA());
    }
}

