/*
 * Decompiled with CFR 0.152.
 */
package deathtags.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import deathtags.core.MMOParties;
import deathtags.helpers.CommandMessageHelper;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class PartyCommand {
    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"party").requires(cs -> cs.func_197034_c(0))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"sub", (ArgumentType)StringArgumentType.string()).executes(ctx -> PartyCommand.run((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"sub"), null))).suggests((SuggestionProvider)new SuggestionProvider<CommandSource>(){

            public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSource> arg0, SuggestionsBuilder arg1) throws CommandSyntaxException {
                return arg1.suggest("invite").suggest("tp").suggest("accept").suggest("deny").suggest("leader").suggest("disband").buildFuture();
            }
        }).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> PartyCommand.run((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"sub"), StringArgumentType.getString((CommandContext)ctx, (String)"player")))).suggests((SuggestionProvider)new SuggestionProvider<CommandSource>(){

            public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSource> arg0, SuggestionsBuilder arg1) throws CommandSyntaxException {
                SuggestionsBuilder builder = arg1;
                for (String playerName : ((CommandSource)arg0.getSource()).func_197028_i().func_184103_al().func_72369_d()) {
                    if (((CommandSource)arg0.getSource()).func_197035_h().func_200200_C_().func_150254_d() == playerName) continue;
                    arg1.suggest(playerName);
                }
                return builder.buildFuture();
            }
        })));
    }

    private static int run(CommandContext<CommandSource> context, String sub, String targetStr) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ServerPlayerEntity target = ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152612_a(targetStr);
        if (player.field_70170_p.field_72995_K) {
            return 0;
        }
        PlayerStats stats = MMOParties.GetStatsByName(player.func_200200_C_().func_150254_d());
        switch (sub) {
            case "tp": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "You must be in a party to teleport someone.");
                    return 0;
                }
                stats.party.Teleport((PlayerEntity)player, (PlayerEntity)target);
                break;
            }
            case "create": {
                Party.Create((PlayerEntity)player);
                break;
            }
            case "invite": {
                if (!stats.InParty()) {
                    Party.Create((PlayerEntity)player);
                }
                stats.party.Invite((PlayerEntity)player, (PlayerEntity)target);
                break;
            }
            case "accept": {
                if (stats.partyInvite == null) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "You do not currently have an invite.");
                    return 0;
                }
                stats.partyInvite.Join((PlayerEntity)player);
                break;
            }
            case "deny": {
                if (stats.partyInvite == null) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "You do not currently have an invite.");
                    return 0;
                }
                stats.partyInvite = null;
                break;
            }
            case "leave": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "You are not currently in a party.");
                    return 0;
                }
                stats.party.Leave((PlayerEntity)player);
                stats.party = null;
                CommandMessageHelper.SendInfo((PlayerEntity)player, "You have left your party.");
                break;
            }
            case "leader": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "You are not currently in a party.");
                    return 0;
                }
                if (stats.party.leader != player) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "Only the leader may promote members.");
                    return 0;
                }
                stats.party.leader = target;
                stats.party.Broadcast(String.format("%s has been given leadership of the party. ", target.func_200200_C_()));
                break;
            }
            case "disband": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "You are not currently in a party.");
                    return 0;
                }
                if (stats.party.leader != player) {
                    CommandMessageHelper.SendError((PlayerEntity)player, "Only the leader may disband.");
                    return 0;
                }
                stats.party.Disband();
                break;
            }
        }
        return 0;
    }
}

