/*
 * Decompiled with CFR 0.152.
 */
package deathtags.config;

public class Color {
    public final float red;
    public final float green;
    public final float blue;

    public Color(String hexString) {
        if (hexString.length() != 6) {
            this.blue = 0.0f;
            this.green = 0.0f;
            this.red = 0.0f;
        } else {
            this.red = (float)(16 * this.hexDigitToInt(hexString.charAt(0)) + this.hexDigitToInt(hexString.charAt(1))) / 255.0f;
            this.green = (float)(16 * this.hexDigitToInt(hexString.charAt(2)) + this.hexDigitToInt(hexString.charAt(3))) / 255.0f;
            this.blue = (float)(16 * this.hexDigitToInt(hexString.charAt(4)) + this.hexDigitToInt(hexString.charAt(5))) / 255.0f;
        }
    }

    public Color(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    private int hexDigitToInt(char c) {
        if ((c = Character.toLowerCase(c)) >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97;
        }
        return 0;
    }
}

