/*
 * Decompiled with CFR 0.152.
 */
package deathtags.events;

import deathtags.core.MMOParties;
import deathtags.stats.PlayerStats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        System.out.println("Player connected to the server.");
        PlayerEntity player = event.getPlayer();
        if (!MMOParties.PlayerStats.containsKey(player)) {
            MMOParties.PlayerStats.put(player, new PlayerStats(player));
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        System.out.println("Player disconnected from the server.");
        if (MMOParties.GetStatsByName(event.getPlayer().func_200200_C_().func_150254_d()) == null) {
            return;
        }
        PlayerStats playerStats = MMOParties.GetStatsByName(event.getPlayer().func_200200_C_().func_150254_d());
        PlayerEntity player = event.getPlayer();
        if (playerStats.InParty()) {
            playerStats.party.Leave(player);
        }
        MMOParties.PlayerStats.remove(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void OnPlayerHurt(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof PlayerEntity) || !(event.getSource().func_76346_g() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        PlayerEntity source = (PlayerEntity)event.getSource().func_76346_g();
        PlayerStats playerStats = MMOParties.GetStatsByName(player.func_200200_C_().func_150254_d());
        PlayerStats sourceStats = MMOParties.GetStatsByName(source.func_200200_C_().func_150254_d());
        if (!playerStats.InParty() || !sourceStats.InParty()) {
            return;
        }
        if (playerStats.party.IsMember(source)) {
            event.setCanceled(true);
        }
        if (playerStats.party.opposer == null) {
            playerStats.party.opposer = sourceStats.party;
            playerStats.party.opposer.opposer = playerStats.party;
        }
    }

    @SubscribeEvent
    public void OnPlayerMove(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = event.player;
        PlayerStats stats = MMOParties.GetStatsByName(player.func_200200_C_().func_150254_d());
        if (stats.teleportTicks > 0) {
            --stats.teleportTicks;
            if (stats.teleportTicks <= 0) {
                stats.CommenceTeleport();
            }
        }
        if (stats.party != null) {
            MMOParties.PlayerStats.get((Object)player).party.SendPartyMemberData(player, false);
        }
        if (!player.func_175149_v()) {
            return;
        }
        if (stats.deathPosition != null && player.func_180425_c().compareTo((Vec3i)stats.deathPosition) != 0) {
            player.func_70107_b((double)stats.deathPosition.func_177958_n(), (double)stats.deathPosition.func_177956_o(), (double)stats.deathPosition.func_177952_p());
        }
    }
}

