/*
 * Decompiled with CFR 0.152.
 */
package deathtags.gui;

import deathtags.core.MMOParties;
import deathtags.stats.PartyMemberData;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class HealthBar {
    public static final ResourceLocation TEXTURE_FRAME = new ResourceLocation("mmoparties", "textures/frame.png");
    public static final ResourceLocation TEXTURE_ICON = new ResourceLocation("mmoparties", "textures/icons.png");
    public static final ResourceLocation TEXTURE_BAR = new ResourceLocation("mmoparties", "textures/bar.png");
    public static final ResourceLocation HEART_TEXTURE = new ResourceLocation("minecraft", "textures/gui/icons.png");
    private Minecraft mc;
    public static float targetHP;
    public static float targetMaxHP;
    private int updateCounter = 0;
    private Random random;

    public HealthBar(Minecraft mc) {
        this.mc = mc;
        this.random = new Random();
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        int posX = 4;
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        if (MMOParties.localParty != null && MMOParties.localParty.local_players.size() >= 1) {
            int pN = 0;
            for (String p_player : MMOParties.localParty.local_players) {
                if (p_player.equals(Minecraft.func_71410_x().field_71439_g.func_200200_C_().func_150254_d())) continue;
                PartyMemberData data = MMOParties.localParty.data.get(p_player);
                this.RenderOwnPartyMember(data, posX, pN, p_player);
                ++pN;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(IngameGui.GUI_ICONS_LOCATION);
    }

    void RenderOwnPartyMember(PartyMemberData data, int posX, int pN, String p_player) {
        if (data == null) {
            return;
        }
        float currentHealth = data.health;
        float maxHealth = data.maxHealth;
        float currentArmor = data.armor;
        float currentAbsorption = data.absorption;
        int iconRows = 0;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HEART_TEXTURE);
        this.drawHealth(posX, 50 + 30 * (pN + 1), currentHealth, maxHealth);
        this.drawHunger(posX, 50 + 10 * ++iconRows + 30 * (pN + 1), data.hunger, 20.0f);
        ++iconRows;
        if (currentAbsorption > 0.0f) {
            this.drawAbsorption(posX, 50 + 10 * iconRows + 30 * (pN + 1), currentAbsorption);
            ++iconRows;
        }
        if (currentArmor > 0.0f) {
            this.drawArmor(posX, 50 + 10 * iconRows + 30 * (pN + 1), currentArmor);
            ++iconRows;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_ICON);
        FontRenderer fontRender = this.mc.field_71466_p;
        String format3 = "%s";
        String str3 = String.format(format3, p_player);
        GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)1.0f);
        if (data.leader) {
            Minecraft.func_71410_x().field_71456_v.blit(10, 31 + 30 * (pN + 1), 0, 18, 9, 9);
        }
        fontRender.func_175063_a(str3, 10.0f, (float)(40 + 30 * (pN + 1)), 0xFFFFFF);
    }

    private void drawHealth(int width, int height, float health, float maxHealth) {
        int left = width / 2;
        int top = height;
        int barLength = 0;
        int i = 0;
        while ((float)i < maxHealth / 2.0f) {
            int dropletHalf = i * 2 + 1;
            int startX = left + barLength * 8 + 9;
            int startY = top;
            if (health <= 6.0f && (float)this.updateCounter % (health * 3.0f + 1.0f) == 0.0f) {
                startY = top + (this.random.nextInt(3) - 1);
            }
            Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 16, 0, 9, 9);
            if ((int)health > dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 52, 0, 9, 9);
            } else if ((int)health == dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 61, 0, 9, 9);
            }
            ++barLength;
            ++i;
        }
    }

    private void drawHunger(int width, int height, float health, float maxHealth) {
        int left = width / 2;
        int top = height;
        int barLength = 0;
        int i = 0;
        while ((float)i < maxHealth / 2.0f) {
            int dropletHalf = i * 2 + 1;
            int startX = left + barLength * 8 + 9;
            int startY = top;
            if (health <= 6.0f && (float)this.updateCounter % (health * 3.0f + 1.0f) == 0.0f) {
                startY = top + (this.random.nextInt(3) - 1);
            }
            Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 16, 27, 9, 9);
            if ((int)health > dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 52, 27, 9, 9);
            } else if ((int)health == dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 61, 27, 9, 9);
            }
            ++barLength;
            ++i;
        }
    }

    private void drawArmor(int width, int height, float armor) {
        int left = width / 2;
        int top = height;
        int barLength = 0;
        int i = 0;
        while ((float)i < armor / 2.0f) {
            int dropletHalf = i * 2 + 1;
            int startX = left + barLength * 8 + 9;
            int startY = top;
            Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 16, 9, 9, 9);
            if ((int)armor > dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 34, 9, 9, 9);
            } else if ((int)armor == dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 25, 9, 9, 9);
            }
            ++barLength;
            GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)1.0f);
            ++i;
        }
    }

    private void drawAbsorption(int width, int height, float armor) {
        int left = width / 2;
        int top = height;
        int bars = 1;
        int barLength = 0;
        int i = 0;
        while ((float)i < armor / 2.0f) {
            int dropletHalf = i * 2 + 1;
            int startX = left + barLength * 8 + 9;
            int startY = top;
            if (bars == 1) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 16, 0, 9, 9);
            }
            if ((int)armor > dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 160, 0, 9, 9);
            } else if ((int)armor == dropletHalf) {
                Minecraft.func_71410_x().field_71456_v.blit(startX, startY, 169, 0, 9, 9);
            }
            if (++barLength >= 10) {
                barLength = 0;
                ++bars;
            }
            GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)1.0f);
            ++i;
        }
    }

    public static void init() {
        System.out.println("Load GUI");
        MinecraftForge.EVENT_BUS.register((Object)new HealthBar(Minecraft.func_71410_x()));
    }
}

