/*
 * Decompiled with CFR 0.152.
 */
package deathtags.stats;

import deathtags.core.MMOParties;
import deathtags.helpers.CommandMessageHelper;
import deathtags.networking.MessageSendMemberData;
import deathtags.networking.MessageUpdateParty;
import deathtags.networking.PartyPacketDataBuilder;
import deathtags.stats.PartyMemberData;
import deathtags.stats.PlayerGroup;
import deathtags.stats.PlayerPing;
import deathtags.stats.PlayerStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.network.NetworkDirection;

public class Party
extends PlayerGroup {
    public List<PlayerEntity> players = new ArrayList<PlayerEntity>();
    public List<String> local_players = new ArrayList<String>();
    public Map<Integer, Party> local_parties = new HashMap<Integer, Party>();
    public Map<String, PartyMemberData> data = new HashMap<String, PartyMemberData>();

    public Party(PlayerEntity player) {
        this.leader = player;
        this.players.add(player);
        this.SendUpdate();
    }

    public Party() {
    }

    public static void Create(PlayerEntity leader) {
        PlayerStats leaderStats = MMOParties.GetStatsByName(leader.func_200200_C_().func_150254_d());
        if (leaderStats.InParty()) {
            CommandMessageHelper.SendError(leader, "You are already in a party.");
            return;
        }
        leaderStats.party = new Party(leader);
        CommandMessageHelper.SendInfo(leader, "You have created a new party.");
    }

    public void Invite(PlayerEntity invoker, PlayerEntity player) {
        PlayerStats targetPlayer = MMOParties.GetStatsByName(player.func_200200_C_().func_150254_d());
        PlayerStats invokerPlayer = MMOParties.GetStatsByName(invoker.func_200200_C_().func_150254_d());
        if (invokerPlayer.party.leader != invoker) {
            CommandMessageHelper.SendError(invoker, "You must be the leader of a party to invite others.");
            return;
        }
        if (targetPlayer.InParty()) {
            CommandMessageHelper.SendError(invoker, String.format("%s is already in a party.", player.func_200200_C_().func_150254_d()));
            return;
        }
        targetPlayer.partyInvite = this;
        CommandMessageHelper.SendInfo(invoker, String.format("You have invited %s to the party.", player.func_200200_C_().func_150254_d()));
        CommandMessageHelper.SendInfo(player, String.format("%s has invited you to join their party.", invoker.func_200200_C_().func_150254_d()));
    }

    public void Join(PlayerEntity player) {
        if (this.players.size() >= 4) {
            CommandMessageHelper.SendError(player, "This party is currently full.");
            return;
        }
        this.players.add(player);
        PlayerStats stats = MMOParties.GetStatsByName(player.func_200200_C_().func_150254_d());
        stats.party = this;
        stats.partyInvite = null;
        this.Broadcast(String.format("%s has joined the party!", player.func_200200_C_().func_150254_d()));
        for (PlayerEntity member : this.players) {
            this.SendPartyMemberData(member, true);
        }
        this.SendUpdate();
    }

    public void Leave(PlayerEntity player) {
        this.players.remove(player);
        this.Broadcast(String.format("%s has left the party..", player.func_200200_C_().func_150254_d()));
        for (PlayerEntity member : this.players) {
            this.SendPartyMemberData(member, true);
        }
        this.SendPartyMemberData(player, true);
        if (player == this.leader && this.players.size() > 0) {
            this.leader = this.players.get(0);
        }
        this.SendUpdate();
        if (this.players.size() == 1) {
            this.Disband();
        }
    }

    public void Disband() {
        this.Broadcast("The party has been disbanded.");
        this.leader = null;
        for (PlayerEntity member : this.players) {
            PlayerStats stats = MMOParties.GetStatsByName(member.func_200200_C_().func_150254_d());
            stats.party = null;
        }
    }

    @Override
    public void Broadcast(String message) {
        for (PlayerEntity member : this.players) {
            CommandMessageHelper.SendInfo(member, message);
        }
    }

    @Override
    public PlayerEntity[] GetOnlinePlayers() {
        return this.players.toArray(new PlayerEntity[0]);
    }

    @Override
    public void SendUpdate() {
        CharSequence[] playerNames = new String[this.players.size()];
        int i = 0;
        for (PlayerEntity party_player : this.players) {
            playerNames[i] = party_player.func_200200_C_().func_150254_d();
            ++i;
        }
        for (PlayerEntity party_player : this.players) {
            if (!(party_player instanceof ServerPlayerEntity)) {
                return;
            }
            MMOParties.network.sendTo((Object)new MessageUpdateParty(String.join((CharSequence)",", playerNames)), ((ServerPlayerEntity)party_player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @Override
    public void SendPartyMemberData(PlayerEntity member, boolean bypassLimit) {
        if (this.IsDataDifferent(member) || bypassLimit) {
            if (!this.pings.containsKey(member.func_200200_C_().func_150254_d())) {
                this.pings.put(member.func_200200_C_().func_150254_d(), new PlayerPing(member, 0.0f, 0.0f, 0.0f, bypassLimit, 0.0f, 0.0f, 0.0f, 0.0f));
            }
            ((PlayerPing)this.pings.get(member.func_200200_C_().func_150254_d())).Update(member.func_110143_aJ(), member.func_110138_aP(), member.func_70658_aO(), this.leader == member, member.func_110139_bj(), 0.0f, 0.0f);
            for (PlayerEntity party_player : this.players) {
                if (!(party_player instanceof ServerPlayerEntity)) {
                    return;
                }
                MMOParties.network.sendTo((Object)new MessageSendMemberData(new PartyPacketDataBuilder().SetPlayer(member.func_200200_C_().func_150254_d()).SetHealth(member.func_110143_aJ()).SetMaxHealth(member.func_110138_aP()).SetArmor(member.func_70658_aO()).SetLeader(this.leader == member).SetAbsorption(member.func_110139_bj()).SetHunger(member.func_71024_bL().func_75116_a())), ((ServerPlayerEntity)party_player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @Override
    public boolean IsDataDifferent(PlayerEntity player) {
        return !this.pings.containsKey(player.func_200200_C_().func_150254_d()) || ((PlayerPing)this.pings.get(player.func_200200_C_().func_150254_d())).IsDifferent(player);
    }

    @Override
    public boolean IsMember(PlayerEntity player) {
        for (PlayerEntity member : this.players) {
            if (!member.func_200200_C_().equals(player.func_200200_C_())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IsAllDead() {
        int numDead = 0;
        for (PlayerEntity player : this.players) {
            if (!player.func_175149_v()) continue;
            ++numDead;
        }
        return numDead == this.players.size();
    }

    @Override
    public void ReviveAll() {
        for (PlayerEntity player : this.players) {
            if (!player.func_175149_v()) continue;
            player.func_71004_bE();
            player.func_71033_a(GameType.SURVIVAL);
        }
    }

    @Override
    public String GetGroupAlias() {
        return "party";
    }

    public void Teleport(PlayerEntity player, PlayerEntity target) {
        if (!this.IsMember(target)) {
            CommandMessageHelper.SendError(player, "You may only teleport to players within your party.");
            return;
        }
        MMOParties.GetStatsByName(player.func_200200_C_().func_150254_d()).StartTeleport(target);
    }
}

