/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.capability.capabilities;

import com.cozary.nameless_trinkets.capability.capabilities.Capability;
import com.cozary.nameless_trinkets.capability.capabilities.CapabilityModel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityProvider
implements ICapabilitySerializable<CompoundNBT> {
    private final CapabilityModel trinketModel;
    private final LazyOptional<CapabilityModel> optional;

    public CapabilityProvider(CapabilityModel trinketModel) {
        this.trinketModel = trinketModel;
        this.optional = LazyOptional.of(() -> trinketModel);
    }

    public void invalidate() {
        this.optional.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull net.minecraftforge.common.capabilities.Capability<T> capability, @Nullable Direction side) {
        if (capability == Capability.INSTANCE) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return this.trinketModel.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.trinketModel.deserializeNBT(nbt);
    }
}

