/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.config;

import com.cozary.nameless_trinkets.config.ConfigHelper;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItemData;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;

public class TrinketConfiguration {
    private static final Path rootPath = ConfigHelper.getRootPath().resolve("trinkets");
    private static Date launchDate;

    public static void setupEverything() {
        TrinketConfiguration.setLaunchDate(new Date());
        TrinketConfiguration.processConfigs();
    }

    private static void processConfigs() {
        ModItems.getTrinketsReg().forEach(trinketItem -> {
            TrinketItemData<?> data = TrinketConfiguration.readConfig(trinketItem);
            if (data == null || data.getConfig() == null || data.getLoot() == null) {
                Path sourcePath = TrinketConfiguration.getRootPath().resolve(trinketItem.getRegistryName().func_110623_a() + ".json");
                if (Files.exists(sourcePath, new LinkOption[0])) {
                    Path backupPath = ConfigHelper.getRootPath().resolve("backups").resolve(new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss").format(TrinketConfiguration.getLaunchDate())).resolve(ConfigHelper.getRootPath().relativize(sourcePath)).getParent();
                    try {
                        Files.createDirectories(backupPath, new FileAttribute[0]);
                        Files.move(sourcePath, backupPath.resolve(trinketItem.getRegistryName().func_110623_a() + ".json"), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                TrinketConfiguration.writeDefaultConfig(trinketItem);
                data = trinketItem.getData().toConfigData();
            }
            TrinketConfiguration.syncTrinketData(trinketItem, data);
        });
    }

    private static void writeDefaultConfig(TrinketItem trinketItem) {
        Path path = TrinketConfiguration.getRootPath();
        Files.createDirectories(path, new FileAttribute[0]);
        ConfigHelper.createJSONConfig(path.resolve(trinketItem.getRegistryName().func_110623_a() + ".json"), trinketItem.getData().toConfigData());
    }

    @Nullable
    private static TrinketItemData readConfig(TrinketItem trinketItem) {
        Object data;
        Path path = TrinketConfiguration.getRootPath().resolve(trinketItem.getRegistryName().func_110623_a() + ".json");
        try {
            data = ConfigHelper.readJSONConfig(path, TypeToken.getParameterized(TrinketItemData.class, (Type[])new Type[]{trinketItem.getData().getConfig()}).getType());
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        if (!(data instanceof TrinketItemData)) {
            return null;
        }
        return (TrinketItemData)data;
    }

    private static void syncTrinketData(TrinketItem trinketItem, TrinketItemData data) {
        TrinketData trinketItemData = trinketItem.getData();
        trinketItemData.setConfig(data.getConfig().getClass());
        trinketItemData.setLoot(data.getLoot());
        trinketItem.setData(trinketItemData);
        trinketItem.setConfig(data.getConfig());
    }

    public static Path getRootPath() {
        return rootPath;
    }

    public static Date getLaunchDate() {
        return launchDate;
    }

    public static void setLaunchDate(Date launchDate) {
        TrinketConfiguration.launchDate = launchDate;
    }
}

