/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.subTrinket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import org.apache.commons.lang3.tuple.MutablePair;

public class TrinketAttribute {
    List<Modifier> attributes;
    List<MutablePair<String, Integer>> slots;

    TrinketAttribute(List<Modifier> attributes, List<MutablePair<String, Integer>> slots) {
        this.attributes = attributes;
        this.slots = slots;
    }

    public static TrinketAttributeBuilder builder() {
        return new TrinketAttributeBuilder();
    }

    public List<Modifier> getAttributes() {
        return this.attributes;
    }

    public List<MutablePair<String, Integer>> getSlots() {
        return this.slots;
    }

    public void setAttributes(List<Modifier> attributes) {
        this.attributes = attributes;
    }

    public void setSlots(List<MutablePair<String, Integer>> slots) {
        this.slots = slots;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrinketAttribute)) {
            return false;
        }
        TrinketAttribute other = (TrinketAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Modifier> this$attributes = this.getAttributes();
        List<Modifier> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<MutablePair<String, Integer>> this$slots = this.getSlots();
        List<MutablePair<String, Integer>> other$slots = other.getSlots();
        return !(this$slots == null ? other$slots != null : !((Object)this$slots).equals(other$slots));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrinketAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Modifier> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<MutablePair<String, Integer>> $slots = this.getSlots();
        result = result * 59 + ($slots == null ? 43 : ((Object)$slots).hashCode());
        return result;
    }

    public String toString() {
        return "TrinketAttribute(attributes=" + this.getAttributes() + ", slots=" + this.getSlots() + ")";
    }

    public static class TrinketAttributeBuilder {
        private ArrayList<Modifier> attributes;
        private ArrayList<MutablePair<String, Integer>> slots;

        TrinketAttributeBuilder() {
        }

        public TrinketAttributeBuilder attribute(Modifier attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(attribute);
            return this;
        }

        public TrinketAttributeBuilder attributes(Collection<? extends Modifier> attributes) {
            if (attributes == null) {
                throw new NullPointerException("attributes cannot be null");
            }
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
            return this;
        }

        public TrinketAttributeBuilder clearAttributes() {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            return this;
        }

        public TrinketAttributeBuilder slot(MutablePair<String, Integer> slot) {
            if (this.slots == null) {
                this.slots = new ArrayList();
            }
            this.slots.add(slot);
            return this;
        }

        public TrinketAttributeBuilder slots(Collection<? extends MutablePair<String, Integer>> slots) {
            if (slots == null) {
                throw new NullPointerException("slots cannot be null");
            }
            if (this.slots == null) {
                this.slots = new ArrayList();
            }
            this.slots.addAll(slots);
            return this;
        }

        public TrinketAttributeBuilder clearSlots() {
            if (this.slots != null) {
                this.slots.clear();
            }
            return this;
        }

        public TrinketAttribute build() {
            List<Object> slots;
            List<Modifier> attributes;
            switch (this.attributes == null ? 0 : this.attributes.size()) {
                case 0: {
                    attributes = Collections.emptyList();
                    break;
                }
                case 1: {
                    attributes = Collections.singletonList(this.attributes.get(0));
                    break;
                }
                default: {
                    attributes = Collections.unmodifiableList(new ArrayList<Modifier>(this.attributes));
                }
            }
            switch (this.slots == null ? 0 : this.slots.size()) {
                case 0: {
                    slots = Collections.emptyList();
                    break;
                }
                case 1: {
                    slots = Collections.singletonList(this.slots.get(0));
                    break;
                }
                default: {
                    slots = Collections.unmodifiableList(new ArrayList<MutablePair<String, Integer>>(this.slots));
                }
            }
            return new TrinketAttribute(attributes, slots);
        }

        public String toString() {
            return "TrinketAttribute.TrinketAttributeBuilder(attributes=" + this.attributes + ", slots=" + this.slots + ")";
        }
    }

    public static class Modifier {
        private final Attribute attribute;
        private final float multiplier;
        private final AttributeModifier.Operation operation;

        public Modifier(Attribute attribute, float multiplier, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.multiplier = multiplier;
            this.operation = operation;
        }

        public Modifier(Attribute attribute, float multiplier) {
            this.attribute = attribute;
            this.multiplier = multiplier;
            this.operation = AttributeModifier.Operation.MULTIPLY_TOTAL;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public float getMultiplier() {
            return this.multiplier;
        }

        public AttributeModifier.Operation getOperation() {
            return this.operation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getMultiplier(), other.getMultiplier()) != 0) {
                return false;
            }
            Attribute this$attribute = this.getAttribute();
            Attribute other$attribute = other.getAttribute();
            if (this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute)) {
                return false;
            }
            AttributeModifier.Operation this$operation = this.getOperation();
            AttributeModifier.Operation other$operation = other.getOperation();
            return !(this$operation == null ? other$operation != null : !this$operation.equals(other$operation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Modifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getMultiplier());
            Attribute $attribute = this.getAttribute();
            result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
            AttributeModifier.Operation $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
            return result;
        }

        public String toString() {
            return "TrinketAttribute.Modifier(attribute=" + this.getAttribute() + ", multiplier=" + this.getMultiplier() + ", operation=" + this.getOperation() + ")";
        }
    }
}

