/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.subTrinket;

import com.cozary.nameless_trinkets.NamelessTrinkets;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItemData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketLoot;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;

public class TrinketData {
    private Item.Properties properties;
    private Rarity rarity;
    private Class<? extends TrinketsStats> config;
    private List<TrinketLoot> loot;

    public TrinketItemData<?> toConfigData() {
        return new TrinketItemData<TrinketsStats>(this.config.newInstance(), this.loot);
    }

    private static Item.Properties $default$properties() {
        return new Item.Properties().func_200916_a(NamelessTrinkets.TAB).func_200917_a(1);
    }

    private static Rarity $default$rarity() {
        return Rarity.EPIC;
    }

    private static Class<? extends TrinketsStats> $default$config() {
        return TrinketsStats.class;
    }

    TrinketData(Item.Properties properties, Rarity rarity, Class<? extends TrinketsStats> config, List<TrinketLoot> loot) {
        this.properties = properties;
        this.rarity = rarity;
        this.config = config;
        this.loot = loot;
    }

    public static TrinketDataBuilder builder() {
        return new TrinketDataBuilder();
    }

    public Item.Properties getProperties() {
        return this.properties;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public Class<? extends TrinketsStats> getConfig() {
        return this.config;
    }

    public List<TrinketLoot> getLoot() {
        return this.loot;
    }

    public void setProperties(Item.Properties properties) {
        this.properties = properties;
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    public void setConfig(Class<? extends TrinketsStats> config) {
        this.config = config;
    }

    public void setLoot(List<TrinketLoot> loot) {
        this.loot = loot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrinketData)) {
            return false;
        }
        TrinketData other = (TrinketData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Item.Properties this$properties = this.getProperties();
        Item.Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        Rarity this$rarity = this.getRarity();
        Rarity other$rarity = other.getRarity();
        if (this$rarity == null ? other$rarity != null : !this$rarity.equals(other$rarity)) {
            return false;
        }
        Class<? extends TrinketsStats> this$config = this.getConfig();
        Class<? extends TrinketsStats> other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        List<TrinketLoot> this$loot = this.getLoot();
        List<TrinketLoot> other$loot = other.getLoot();
        return !(this$loot == null ? other$loot != null : !((Object)this$loot).equals(other$loot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrinketData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Item.Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        Rarity $rarity = this.getRarity();
        result = result * 59 + ($rarity == null ? 43 : $rarity.hashCode());
        Class<? extends TrinketsStats> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        List<TrinketLoot> $loot = this.getLoot();
        result = result * 59 + ($loot == null ? 43 : ((Object)$loot).hashCode());
        return result;
    }

    public String toString() {
        return "TrinketData(properties=" + this.getProperties() + ", rarity=" + this.getRarity() + ", config=" + this.getConfig() + ", loot=" + this.getLoot() + ")";
    }

    public static class TrinketDataBuilder {
        private boolean properties$set;
        private Item.Properties properties$value;
        private boolean rarity$set;
        private Rarity rarity$value;
        private boolean config$set;
        private Class<? extends TrinketsStats> config$value;
        private ArrayList<TrinketLoot> loot;

        TrinketDataBuilder() {
        }

        public TrinketDataBuilder properties(Item.Properties properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        public TrinketDataBuilder rarity(Rarity rarity) {
            this.rarity$value = rarity;
            this.rarity$set = true;
            return this;
        }

        public TrinketDataBuilder config(Class<? extends TrinketsStats> config) {
            this.config$value = config;
            this.config$set = true;
            return this;
        }

        public TrinketDataBuilder loot(TrinketLoot loot) {
            if (this.loot == null) {
                this.loot = new ArrayList();
            }
            this.loot.add(loot);
            return this;
        }

        public TrinketDataBuilder loot(Collection<? extends TrinketLoot> loot) {
            if (loot == null) {
                throw new NullPointerException("loot cannot be null");
            }
            if (this.loot == null) {
                this.loot = new ArrayList();
            }
            this.loot.addAll(loot);
            return this;
        }

        public TrinketDataBuilder clearLoot() {
            if (this.loot != null) {
                this.loot.clear();
            }
            return this;
        }

        public TrinketData build() {
            List<TrinketLoot> loot;
            switch (this.loot == null ? 0 : this.loot.size()) {
                case 0: {
                    loot = Collections.emptyList();
                    break;
                }
                case 1: {
                    loot = Collections.singletonList(this.loot.get(0));
                    break;
                }
                default: {
                    loot = Collections.unmodifiableList(new ArrayList<TrinketLoot>(this.loot));
                }
            }
            Item.Properties properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = TrinketData.$default$properties();
            }
            Rarity rarity$value = this.rarity$value;
            if (!this.rarity$set) {
                rarity$value = TrinketData.$default$rarity();
            }
            Class config$value = this.config$value;
            if (!this.config$set) {
                config$value = TrinketData.$default$config();
            }
            return new TrinketData(properties$value, rarity$value, config$value, loot);
        }

        public String toString() {
            return "TrinketData.TrinketDataBuilder(properties$value=" + this.properties$value + ", rarity$value=" + this.rarity$value + ", config$value=" + this.config$value + ", loot=" + this.loot + ")";
        }
    }
}

