/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.subTrinket;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketAttribute;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class TrinketItem<T extends TrinketsStats>
extends Item
implements ICurioItem {
    protected TrinketData data;
    protected T config;

    public TrinketItem(TrinketData data) {
        super(data.getRarity() == null ? data.getProperties() : data.getProperties().func_208103_a(data.getRarity()));
        this.setData(data);
        this.setConfig(data.getConfig().newInstance());
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity entity = slotContext.getWearer();
        TrinketAttribute modifiers = this.getAttributes(stack);
        if (modifiers == null) {
            return;
        }
        modifiers.getAttributes().forEach(attribute -> EntityUtils.applyAttribute(entity, stack, attribute.getAttribute(), attribute.getMultiplier(), attribute.getOperation()));
        modifiers.getSlots().forEach(slot -> {
            String identifier = (String)slot.getLeft();
            int amount = (Integer)slot.getRight();
            if (amount == 0 || !identifier.equals("talisman")) {
                return;
            }
            CuriosApi.getSlotHelper().setSlotsForType(identifier, entity, amount);
        });
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.getWearer();
        TrinketAttribute modifiers = this.getAttributes(stack);
        if (modifiers == null || stack.func_77973_b() == newStack.func_77973_b()) {
            return;
        }
        modifiers.getAttributes().forEach(attribute -> EntityUtils.removeAttribute(entity, stack, attribute.getAttribute(), attribute.getMultiplier(), attribute.getOperation()));
        modifiers.getSlots().forEach(slot -> {
            String identifier = (String)slot.getLeft();
            int amount = (Integer)slot.getRight();
            if (amount == 0 || !identifier.equals("talisman")) {
                return;
            }
            CuriosApi.getSlotHelper().setSlotsForType(identifier, entity, 0);
        });
    }

    public TrinketAttribute getAttributes(ItemStack stack) {
        return null;
    }

    public TrinketData getData() {
        return this.data;
    }

    public void setData(TrinketData data) {
        this.data = data;
    }

    public T getConfig() {
        return this.config;
    }

    public void setConfig(T config) {
        this.config = config;
    }
}

