/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.subTrinket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TrinketLoot {
    private List<String> table;
    private float chance;

    private static float $default$chance() {
        return 0.1f;
    }

    TrinketLoot(List<String> table, float chance) {
        this.table = table;
        this.chance = chance;
    }

    public static TrinketLootBuilder builder() {
        return new TrinketLootBuilder();
    }

    public List<String> getTable() {
        return this.table;
    }

    public float getChance() {
        return this.chance;
    }

    public static class TrinketLootBuilder {
        private ArrayList<String> table;
        private boolean chance$set;
        private float chance$value;

        TrinketLootBuilder() {
        }

        public TrinketLootBuilder table(String table) {
            if (this.table == null) {
                this.table = new ArrayList();
            }
            this.table.add(table);
            return this;
        }

        public TrinketLootBuilder table(Collection<? extends String> table) {
            if (table == null) {
                throw new NullPointerException("table cannot be null");
            }
            if (this.table == null) {
                this.table = new ArrayList();
            }
            this.table.addAll(table);
            return this;
        }

        public TrinketLootBuilder clearTable() {
            if (this.table != null) {
                this.table.clear();
            }
            return this;
        }

        public TrinketLootBuilder chance(float chance) {
            this.chance$value = chance;
            this.chance$set = true;
            return this;
        }

        public TrinketLoot build() {
            List<String> table;
            switch (this.table == null ? 0 : this.table.size()) {
                case 0: {
                    table = Collections.emptyList();
                    break;
                }
                case 1: {
                    table = Collections.singletonList(this.table.get(0));
                    break;
                }
                default: {
                    table = Collections.unmodifiableList(new ArrayList<String>(this.table));
                }
            }
            float chance$value = this.chance$value;
            if (!this.chance$set) {
                chance$value = TrinketLoot.$default$chance();
            }
            return new TrinketLoot(table, chance$value);
        }

        public String toString() {
            return "TrinketLoot.TrinketLootBuilder(table=" + this.table + ", chance$value=" + this.chance$value + ")";
        }
    }
}

