/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.utils;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.item.ItemStack;

public class EntityUtils {
    private static String getAttributeName(ItemStack stack, Attribute attribute) {
        return stack.func_77973_b().getRegistryName().func_110623_a() + "_" + attribute.getRegistryName().func_110623_a();
    }

    public static boolean applyAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, float value, AttributeModifier.Operation operation) {
        String name = EntityUtils.getAttributeName(stack, attribute);
        if (name.equals("")) {
            return false;
        }
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        ModifiableAttributeInstance instance = entity.func_110148_a(attribute);
        AttributeModifier modifier = new AttributeModifier(uuid, name, (double)value, operation);
        if (instance == null || instance.func_180374_a(modifier)) {
            return false;
        }
        instance.func_233767_b_(modifier);
        return true;
    }

    public static boolean removeAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, float value, AttributeModifier.Operation operation) {
        String name = EntityUtils.getAttributeName(stack, attribute);
        if (name.equals("")) {
            return false;
        }
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        ModifiableAttributeInstance instance = entity.func_110148_a(attribute);
        AttributeModifier modifier = new AttributeModifier(uuid, name, (double)value, operation);
        if (instance == null || !instance.func_180374_a(modifier)) {
            return false;
        }
        instance.func_111124_b(modifier);
        return true;
    }

    public static void applyAttributeModifier(ModifiableAttributeInstance instance, AttributeModifier modifier) {
        if (!instance.func_180374_a(modifier)) {
            instance.func_233767_b_(modifier);
        }
    }

    public static void removeAttributeModifier(ModifiableAttributeInstance instance, AttributeModifier modifier) {
        if (instance.func_180374_a(modifier)) {
            instance.func_111124_b(modifier);
        }
    }
}

