/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MaxHealthFix {
    public static final String TAG_NAME = "MaxHealthFixPrevAmount";
    private final List<ServerPlayerEntity> joiningPlayerQueue = new ArrayList<ServerPlayerEntity>();

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            this.joiningPlayerQueue.add((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            player.getPersistentData().func_74776_a(TAG_NAME, event.getPlayer().func_110143_aJ());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.joiningPlayerQueue.isEmpty()) {
            Iterator<ServerPlayerEntity> iter = this.joiningPlayerQueue.iterator();
            while (iter.hasNext()) {
                ServerPlayerEntity player = iter.next();
                iter.remove();
                CompoundNBT playerData = player.getPersistentData();
                if (playerData == null || !playerData.func_74764_b(TAG_NAME)) continue;
                float oldHealth = playerData.func_74760_g(TAG_NAME);
                float currentHealth = player.func_110143_aJ();
                playerData.func_82580_o(TAG_NAME);
                if (!(oldHealth > currentHealth)) continue;
                float correctedHealth = Math.min(oldHealth, player.func_110138_aP());
                player.func_70606_j(correctedHealth);
            }
        }
    }
}

