/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NewCapabilities {
    public static final Capability<ITrinketsData> TRINKETS_DATA_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITrinketsData>(){});
    public static final ResourceLocation ID = new ResourceLocation("nameless_trinkets", "trinkets_data");
    private static final String PLAYER_LEVEL_TAG = "playerLevel";
    private static final String RAGE_TAG = "rage";
    private static final String OLD_RAGE_TAG = "oldRage";
    private static final String WOODEN_STICK_TAG = "woodenStick";
    private static final String SIGIL_TAG = "sigil";
    private static final String TICK_TAG = "tick";
    private static final String TICK_CREEPER_TAG = "tickCreeper";
    private static final String TICK_CREEPER_PAUSE_TAG = "tickCreeperPause";
    private static final String TICK_VAMPIRE_PAUSE_TAG = "tickVampirePause";
    private static final String CREEPER_TAG = "creeper";

    public static LazyOptional<ITrinketsData> getCapability(Player player) {
        return player.getCapability(TRINKETS_DATA_CAP);
    }

    public static class CapabilityEvents {
        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            Entity entity = (Entity)evt.getObject();
            if (entity instanceof Player) {
                evt.addCapability(ID, (ICapabilityProvider)new Provider());
            }
        }

        @SubscribeEvent
        public void onPlayerDeath(PlayerEvent.Clone evt) {
            if (evt.isWasDeath()) {
                Player player = evt.getPlayer();
                Player original = evt.getOriginal();
                original.revive();
                NewCapabilities.getCapability(player).ifPresent(sleepdata -> NewCapabilities.getCapability(original).ifPresent(sleepdata::copyFrom));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ITrinketsData> optional;
        final ITrinketsData data = new SleepDataWrapper();

        Provider() {
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction side) {
            return TRINKETS_DATA_CAP.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128350_(NewCapabilities.PLAYER_LEVEL_TAG, this.data.getPlayerLevel());
            compound.m_128350_(NewCapabilities.RAGE_TAG, SleepDataWrapper.rage);
            compound.m_128350_(NewCapabilities.OLD_RAGE_TAG, this.data.getOldRage());
            compound.m_128350_(NewCapabilities.WOODEN_STICK_TAG, SleepDataWrapper.woodenStick);
            compound.m_128350_(NewCapabilities.SIGIL_TAG, this.data.getSigil());
            compound.m_128350_(NewCapabilities.TICK_TAG, this.data.getTick());
            compound.m_128350_(NewCapabilities.TICK_CREEPER_TAG, this.data.getTickCreeper());
            compound.m_128350_(NewCapabilities.TICK_CREEPER_PAUSE_TAG, this.data.getTickCreeperPause());
            compound.m_128350_(NewCapabilities.TICK_VAMPIRE_PAUSE_TAG, this.data.getTickVampirePause());
            compound.m_128379_(NewCapabilities.CREEPER_TAG, this.data.getCreeper());
            return compound;
        }

        public void deserializeNBT(Tag nbt) {
            CompoundTag compound = (CompoundTag)nbt;
            this.data.setPlayerLevel(compound.m_128457_(NewCapabilities.PLAYER_LEVEL_TAG));
            this.data.setRage(compound.m_128457_(NewCapabilities.RAGE_TAG));
            this.data.setOldRage(compound.m_128457_(NewCapabilities.OLD_RAGE_TAG));
            this.data.setWoodenStick(compound.m_128457_(NewCapabilities.WOODEN_STICK_TAG));
            this.data.setSigil(compound.m_128457_(NewCapabilities.SIGIL_TAG));
            this.data.setTick(compound.m_128457_(NewCapabilities.TICK_TAG));
            this.data.setTickCreeper(compound.m_128457_(NewCapabilities.TICK_CREEPER_TAG));
            this.data.setTickCreeperPause(compound.m_128457_(NewCapabilities.TICK_CREEPER_PAUSE_TAG));
            this.data.setTickVampirePause(compound.m_128457_(NewCapabilities.TICK_VAMPIRE_PAUSE_TAG));
            this.data.setCreeper(compound.m_128471_(NewCapabilities.CREEPER_TAG));
        }
    }

    public static class SleepDataWrapper
    implements ITrinketsData {
        static float rage = 0.0f;
        static float woodenStick = 20.0f;
        float playerLevel = 0.0f;
        float oldRage = 0.0f;
        float sigil = 0.0f;
        float tick = 0.0f;
        float tickCreeper = 0.0f;
        float tickCreeperPause = 0.0f;
        float tickVampirePause = 0.0f;
        boolean creeper = false;

        public static float getRage() {
            return rage;
        }

        public static float getWoodenStick() {
            return woodenStick;
        }

        @Override
        public float getPlayerLevel() {
            return this.playerLevel;
        }

        @Override
        public float setPlayerLevel(float count) {
            this.playerLevel = count;
            return this.playerLevel;
        }

        @Override
        public float setRage(float count) {
            rage = count;
            return rage;
        }

        @Override
        public float getOldRage() {
            return this.oldRage;
        }

        @Override
        public float setOldRage(float count) {
            this.oldRage = count;
            return this.oldRage;
        }

        @Override
        public float setWoodenStick(float count) {
            woodenStick = count;
            return woodenStick;
        }

        @Override
        public float getSigil() {
            return this.sigil;
        }

        @Override
        public float setSigil(float count) {
            this.sigil = count;
            return this.sigil;
        }

        @Override
        public float getTick() {
            return this.tick;
        }

        @Override
        public float setTick(float count) {
            this.tick = count;
            return this.tick;
        }

        @Override
        public boolean getCreeper() {
            return this.creeper;
        }

        @Override
        public boolean setCreeper(boolean count) {
            this.creeper = count;
            return this.creeper;
        }

        @Override
        public float getTickCreeper() {
            return this.tickCreeper;
        }

        @Override
        public float setTickCreeper(float count) {
            this.tickCreeper = count;
            return this.tickCreeper;
        }

        @Override
        public float getTickCreeperPause() {
            return this.tickCreeperPause;
        }

        @Override
        public float setTickCreeperPause(float count) {
            this.tickCreeperPause = count;
            return this.tickCreeperPause;
        }

        @Override
        public float getTickVampirePause() {
            return this.tickVampirePause;
        }

        @Override
        public float setTickVampirePause(float count) {
            this.tickVampirePause = count;
            return this.tickVampirePause;
        }

        @Override
        public void copyFrom(ITrinketsData other) {
            this.setPlayerLevel(other.getPlayerLevel());
            this.setOldRage(other.getOldRage());
            this.setSigil(other.getSigil());
            this.setTick(other.getTick());
            this.setCreeper(other.getCreeper());
            this.setTickCreeper(other.getTickCreeper());
            this.setTickCreeperPause(other.getTickCreeperPause());
            this.setTickVampirePause(other.getTickVampirePause());
        }
    }

    public static interface ITrinketsData {
        public float getPlayerLevel();

        public float setPlayerLevel(float var1);

        public float setRage(float var1);

        public float getOldRage();

        public float setOldRage(float var1);

        public float setWoodenStick(float var1);

        public float getSigil();

        public float setSigil(float var1);

        public float getTick();

        public float setTick(float var1);

        public boolean getCreeper();

        public boolean setCreeper(boolean var1);

        public float getTickCreeper();

        public float setTickCreeper(float var1);

        public float getTickCreeperPause();

        public float setTickCreeperPause(float var1);

        public float getTickVampirePause();

        public float setTickVampirePause(float var1);

        public void copyFrom(ITrinketsData var1);
    }
}

