/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketLoot;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.TrinketsLootTables;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class Gills
extends TrinketItem<Stats>
implements ICurioItem {
    public static Gills INSTANCE;

    public Gills() {
        super(TrinketData.builder().config(Stats.class).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.WORLD_SPAWN).chance(1.0f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.TWOPERCENT).chance(0.02f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.QUARTERPERCENT).chance(0.25f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.SEVENPERCENT).chance(0.07f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.SEVENTYPERCENT).chance(0.7f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.TENPERCENT).chance(0.1f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.THIRTYPERCENT).chance(0.3f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.TWENTYPERCENT).chance(0.2f).build()).build());
        INSTANCE = this;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.GILLS.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent(ChatFormatting.AQUA + ChatFormatting.ITALIC + "I'm under water."));
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent(ChatFormatting.GOLD + "You can breathe" + ChatFormatting.BLUE + " underwater."));
            tooltip.add((Component)new TranslatableComponent(ChatFormatting.GOLD + "You cannot breathe" + ChatFormatting.BLUE + " air."));
            tooltip.add((Component)new TranslatableComponent(ChatFormatting.GRAY + "Only removable while you are underwater."));
        } else {
            tooltip.add((Component)new TranslatableComponent(ChatFormatting.WHITE + "Hold" + ChatFormatting.GOLD + ChatFormatting.BOLD + " Shift " + ChatFormatting.WHITE + "For Info"));
        }
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        Player player = (Player)livingEntity;
        return livingEntity.m_19941_((Tag)FluidTags.f_13131_) || player.m_150110_().f_35937_;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        Stats config = (Stats)INSTANCE.getConfig();
        if (livingEntity.m_20146_() <= -20) {
            Vec3 vector3d = livingEntity.m_20184_();
            livingEntity.m_20301_(0);
            Random random = new Random();
            for (int i = 0; i < 8; ++i) {
                double d2 = random.nextDouble() - random.nextDouble();
                double d3 = random.nextDouble() - random.nextDouble();
                double d4 = random.nextDouble() - random.nextDouble();
                livingEntity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, livingEntity.m_20185_() + d2, livingEntity.m_20186_() + d3, livingEntity.m_20189_() + d4, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
            }
            if (config.blindnessWhenChoking) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 10, false, false));
                livingEntity.m_6469_(DamageSource.f_19312_, config.chokingDamage);
            }
        } else if (!livingEntity.m_19941_((Tag)FluidTags.f_13131_) || livingEntity.f_19853_.m_8055_(new BlockPos(livingEntity.m_20185_(), livingEntity.m_20188_(), livingEntity.m_20189_())).m_60713_(Blocks.f_50628_)) {
            livingEntity.m_20301_(livingEntity.m_20146_() - config.airReductionSpeed);
        } else {
            livingEntity.m_20301_(300);
        }
    }

    public static class Stats
    extends TrinketsStats {
        public float chokingDamage = 2.0f;
        public boolean blindnessWhenChoking = true;
        public int airReductionSpeed = 7;
    }
}

