/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketLoot;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import com.cozary.nameless_trinkets.utils.TrinketsLootTables;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class MoonStone
extends TrinketItem<Stats>
implements ICurioItem {
    public static MoonStone INSTANCE;
    private final MutablePair<String, UUID> MoonStone_MOD = new MutablePair((Object)"nameless_trinkets:moon_stone_gravity", (Object)UUID.randomUUID());

    public MoonStone() {
        super(TrinketData.builder().config(Stats.class).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.WORLD_SPAWN).chance(1.0f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.TWOPERCENT).chance(0.02f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.QUARTERPERCENT).chance(0.25f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.SEVENPERCENT).chance(0.07f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.SEVENTYPERCENT).chance(0.7f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.TENPERCENT).chance(0.1f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.THIRTYPERCENT).chance(0.3f).build()).loot(TrinketLoot.builder().table(TrinketsLootTables.LootTable.TWENTYPERCENT).chance(0.2f).build()).build());
        INSTANCE = this;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.AQUA + ChatFormatting.ITALIC + "Moon Gravity.")));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.DARK_AQUA + String.format("%.1f", config.gravityValue * 100.0 / 0.08) + "% " + ChatFormatting.GOLD + "Gravity.")));
            tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.GOLD + "No" + ChatFormatting.RED + " Fall Damage.")));
        } else {
            tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.WHITE + "Hold" + ChatFormatting.GOLD + ChatFormatting.BOLD + " Shift " + ChatFormatting.WHITE + "For Info")));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.MOON_STONE.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.m_20193_();
        if (world.m_5776_() || livingEntity.f_19797_ % 20 != 0) {
            return;
        }
        AttributeInstance attribSpeed = livingEntity.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        AttributeModifier speedModifier = new AttributeModifier((UUID)this.MoonStone_MOD.getRight(), (String)this.MoonStone_MOD.getLeft(), ((Stats)this.config).gravityValue, AttributeModifier.Operation.ADDITION);
        assert (attribSpeed != null);
        EntityUtils.applyAttributeModifier(attribSpeed, speedModifier);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.getWearer().m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get())), new AttributeModifier((UUID)this.MoonStone_MOD.getRight(), (String)this.MoonStone_MOD.getLeft(), ((Stats)this.config).gravityValue, AttributeModifier.Operation.ADDITION));
    }

    public static class Stats
    extends TrinketsStats {
        public double gravityValue = -0.07;
    }
}

