/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MaxHealthFix {
    public static final String TAG_NAME = "MaxHealthFixPrevAmount";
    private final List<ServerPlayer> joiningPlayerQueue = new ArrayList<ServerPlayer>();

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.joiningPlayerQueue.add((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getPersistentData().m_128350_(TAG_NAME, event.getEntity().m_21223_());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.joiningPlayerQueue.isEmpty()) {
            Iterator<ServerPlayer> iter = this.joiningPlayerQueue.iterator();
            while (iter.hasNext()) {
                ServerPlayer player = iter.next();
                iter.remove();
                CompoundTag playerData = player.getPersistentData();
                if (playerData == null || !playerData.m_128441_(TAG_NAME)) continue;
                float oldHealth = playerData.m_128457_(TAG_NAME);
                float currentHealth = player.m_21223_();
                playerData.m_128473_(TAG_NAME);
                if (!(oldHealth > currentHealth)) continue;
                float correctedHealth = Math.min(oldHealth, player.m_21233_());
                player.m_21153_(correctedHealth);
            }
        }
    }
}

