/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.event;

import com.cozary.nameless_trinkets.capability.NewCapabilities;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.init.ModItemsExpand;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.trinkets.AmphibiousHands;
import com.cozary.nameless_trinkets.items.trinkets.BlazeNucleus;
import com.cozary.nameless_trinkets.items.trinkets.BrokenAnkh;
import com.cozary.nameless_trinkets.items.trinkets.Callus;
import com.cozary.nameless_trinkets.items.trinkets.CreeperSense;
import com.cozary.nameless_trinkets.items.trinkets.ExperienceBattery;
import com.cozary.nameless_trinkets.items.trinkets.ExplosionProofJacket;
import com.cozary.nameless_trinkets.items.trinkets.GhastEye;
import com.cozary.nameless_trinkets.items.trinkets.IceCube;
import com.cozary.nameless_trinkets.items.trinkets.LuckyHorseshoe;
import com.cozary.nameless_trinkets.items.trinkets.LuckyRock;
import com.cozary.nameless_trinkets.items.trinkets.MissingPage;
import com.cozary.nameless_trinkets.items.trinkets.PufferFishLiver;
import com.cozary.nameless_trinkets.items.trinkets.Reforger;
import com.cozary.nameless_trinkets.items.trinkets.ReverseCard;
import com.cozary.nameless_trinkets.items.trinkets.SleepingPills;
import com.cozary.nameless_trinkets.items.trinkets.SpiderLegs;
import com.cozary.nameless_trinkets.items.trinkets.Tick;
import com.cozary.nameless_trinkets.items.trinkets.TrueHeartOfTheSea;
import com.cozary.nameless_trinkets.items.trinkets.VampireBlood;
import com.cozary.nameless_trinkets.items.trinkets.WoodenStick;
import com.cozary.nameless_trinkets.utils.ConfigurationHandler;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class EventHandler {
    public static boolean isValidTarget(LivingEntity ent) {
        return ent.m_6095_() != EntityType.f_20532_ && !ent.m_20147_();
    }

    @SubscribeEvent
    public void MissingPage(LivingDamageEvent event) {
        MissingPage.Stats config = (MissingPage.Stats)MissingPage.INSTANCE.getConfig();
        DamageSource source = event.getSource();
        Entity src = source.m_7639_();
        Random random = new Random();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.MISSING_PAGE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!stack.m_41619_() && random.nextInt(100) <= config.activationPercentage) {
                AABB targetBox = new AABB(player.m_20182_(), player.m_20182_()).m_82400_((double)config.radiusInBlocks);
                List foundTarget = event.getEntity().f_19853_.m_6443_(LivingEntity.class, targetBox, EventHandler::isValidTarget);
                if (!(src == null || src instanceof Player || foundTarget.isEmpty() || player.f_19853_.f_46443_)) {
                    for (LivingEntity livingEntity2 : foundTarget) {
                        ((ServerLevel)livingEntity2.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123746_, livingEntity2.m_20185_(), livingEntity2.m_20186_(), livingEntity2.m_20189_(), 35, 1.0, 1.0, 1.0, 0.1);
                        livingEntity2.m_6469_(DamageSource.f_19318_, livingEntity2.m_21233_() * (config.percentageOfDamage / 100.0f));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void ReverseCard(LivingAttackEvent event) {
        ReverseCard.Stats config = (ReverseCard.Stats)ReverseCard.INSTANCE.getConfig();
        DamageSource source = event.getSource();
        Entity src = source.m_7639_();
        Random random = new Random();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.REVERSE_CARD.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!(stack.m_41619_() || random.nextInt(100) > config.chanceToActivate || src == null || src instanceof Player || player.f_19853_.f_46443_)) {
                ((ServerLevel)src.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123771_, src.m_20185_(), src.m_20186_(), src.m_20189_(), 35, 1.0, 1.0, 1.0, 0.1);
                src.m_6469_(DamageSource.f_19318_, event.getAmount());
            }
        }
    }

    @SubscribeEvent
    public void ExperienceBattery(TickEvent.PlayerTickEvent event) {
        ExperienceBattery.Stats config = (ExperienceBattery.Stats)ExperienceBattery.INSTANCE.getConfig();
        if (event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            int level = event.player.f_36078_;
            float levelMultiplier = config.experienceMultiplier;
            ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.EXPERIENCE_BATTERY.get(), (LivingEntity)event.player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!stack.m_41619_() && player instanceof ServerPlayer) {
                NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                    if (trinketsData.getPlayerLevel() > (float)level) {
                        trinketsData.setPlayerLevel(level);
                    } else if (trinketsData.getPlayerLevel() < (float)level) {
                        if (level <= 15) {
                            event.player.m_6756_((int)((float)(17 * level) * levelMultiplier));
                            trinketsData.setPlayerLevel(level);
                        } else if (level > 16 && level <= 30) {
                            int exp = (int)Math.pow(level, 2.0);
                            event.player.m_6756_((int)((1.5 * (double)exp - 29.5 * (double)level + 360.0) * (double)levelMultiplier));
                            trinketsData.setPlayerLevel(level);
                        } else if (level > 31 && level <= 100) {
                            int exp = (int)Math.pow(level, 2.0);
                            event.player.m_6756_((int)((3.5 * (double)exp - 151.5 * (double)level + 2220.0) * (double)levelMultiplier / 4.0));
                            trinketsData.setPlayerLevel(level);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void BrokenAnkh(LivingDeathEvent event) {
        BrokenAnkh.Stats config = (BrokenAnkh.Stats)BrokenAnkh.INSTANCE.getConfig();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.BROKEN_ANKH.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!stack.m_41619_() && player.m_21224_() && !player.m_36335_().m_41519_(stack.m_41720_()) && !player.f_19853_.f_46443_) {
                ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 1.0, 1.0, 1.0, 0.1);
                ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123777_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 1.0, 1.0, 0.1);
                ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123789_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 1.0, 1.0, 1.0, 0.1);
                event.setCanceled(true);
                player.m_21153_(2.0f);
                player.m_21219_();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
                player.m_36335_().m_41524_(stack.m_41720_(), config.cooldown);
            }
        }
    }

    @SubscribeEvent
    public void Callus(LivingHurtEvent event) {
        Callus.Stats config = (Callus.Stats)Callus.INSTANCE.getConfig();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            ItemStack stack0;
            Player player = (Player)livingEntity;
            if (event.getEntity() == player && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CALLUS.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_()) {
                if (event.getSource() == DamageSource.f_19314_ || event.getSource() == DamageSource.f_19321_ || event.getSource() == DamageSource.f_19309_ || event.getSource() == DamageSource.f_19325_) {
                    event.setAmount(0.0f);
                } else if (event.getSource() == DamageSource.f_19315_) {
                    event.setAmount(event.getAmount() * (1.0f - config.fallDamageReductionPercentage / 100.0f));
                } else {
                    event.setAmount(event.getAmount() * (1.0f - config.generalDamageReductionPercentage / 100.0f));
                }
            }
        }
    }

    @SubscribeEvent
    public void SpeedForce(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) != null) {
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.SPEED_FORCE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!player.f_19853_.f_46443_ && !stack0.m_41619_()) {
                Vec3 vector3d = player.m_20184_();
                ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 5, vector3d.f_82479_ * -4.0, 0.3, vector3d.f_82481_ * -4.0, 0.1);
            }
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.SPEED_FORCE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            ItemStack stack1 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CRACKED_CROWN.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            ItemStack stack2 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.STABLE_CROWN.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!(stack0.m_41619_() && stack1.m_41619_() && stack2.m_41619_())) {
                event.setNewFovModifier(1.0f);
            }
        }
    }

    @SubscribeEvent
    public void VampireBlood(LivingDeathEvent event) {
        VampireBlood.Stats config = (VampireBlood.Stats)VampireBlood.INSTANCE.getConfig();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.VAMPIRE_BLOOD.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!stack0.m_41619_() && !player.f_19853_.f_46443_) {
                ((ServerLevel)event.getEntity().m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123763_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), 35, 1.0, 1.0, 1.0, 0.1);
                player.m_5634_(event.getEntity().m_21233_() * (config.healingPercentage / 100.0f));
            }
        }
    }

    @SubscribeEvent
    public void VampireWeak(TickEvent.PlayerTickEvent event) {
        ItemStack stack0;
        Player player;
        VampireBlood.Stats config = (VampireBlood.Stats)VampireBlood.INSTANCE.getConfig();
        if (event.phase == TickEvent.Phase.START && (player = event.player) != null && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.VAMPIRE_BLOOD.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && player instanceof ServerPlayer) {
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (player.f_19853_.m_46461_()) {
                    if (!player.f_19853_.m_45527_(player.m_20183_()) && trinketsData.getTickVampirePause() != 0.0f) {
                        trinketsData.setTickVampirePause(0.0f);
                    } else if (trinketsData.getTickVampirePause() == 200.0f && !player.f_19853_.f_46443_) {
                        ((ServerLevel)event.player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 35, 1.0, 1.0, 1.0, 0.1);
                        player.m_6469_(DamageSource.f_19307_, (float)config.sunDamage);
                        trinketsData.setTickVampirePause(0.0f);
                    } else if (player.f_19853_.m_45527_(player.m_20183_()) && trinketsData.getTickVampirePause() >= 0.0f) {
                        trinketsData.setTickVampirePause(trinketsData.getTickVampirePause() + 1.0f);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void LuckyRock(BlockEvent.BreakEvent event) {
        LuckyRock.Stats config = (LuckyRock.Stats)LuckyRock.INSTANCE.getConfig();
        Player player = event.getPlayer();
        Level world = player.f_19853_;
        Random random = new Random();
        ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.LUCKY_ROCK.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
        if (!stack0.m_41619_() && random.nextInt(100) <= config.percentageOfObtaining && event.getState() == Blocks.f_50069_.m_49966_() && !player.f_19853_.f_46443_) {
            String itemStack = config.blockList.get(random.nextInt(config.blockList.size()));
            BlockPos pos = player.m_20183_();
            assert (itemStack != null);
            ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 25, 1.0, 1.0, 1.0, 0.1);
            ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemStack))).m_7968_());
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
        }
    }

    @SubscribeEvent
    public void PufferFishPoison(LivingHurtEvent event) {
        ItemStack stack0;
        PufferFishLiver.Stats config = (PufferFishLiver.Stats)PufferFishLiver.INSTANCE.getConfig();
        DamageSource source = event.getSource();
        Entity src = source.m_7639_();
        Random random = new Random();
        if (src instanceof Player && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.PUFFER_FISH_LIVER.get(), (LivingEntity)src).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && random.nextInt(100) <= config.chanceToApplyPoison) {
            MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.f_19614_, config.poisonTime, config.poisonLevel);
            LivingEntity potionGo = event.getEntity();
            potionGo.m_7292_(effectinstance);
        }
    }

    @SubscribeEvent
    public void PufferFishAntiPoison(TickEvent.PlayerTickEvent event) {
        ItemStack stack0;
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) != null && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.PUFFER_FISH_LIVER.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && player.m_21023_(MobEffects.f_19614_)) {
            player.m_21195_(MobEffects.f_19614_);
        }
    }

    @SubscribeEvent
    public void RageMind(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.RAGE_MIND.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!stack.m_41619_()) {
                NewCapabilities.getCapability(player).ifPresent(trinketsData -> trinketsData.setRage(NewCapabilities.SleepDataWrapper.getRage() + event.getAmount()));
            }
        }
    }

    @SubscribeEvent
    public void RageForce(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.RAGE_MIND.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (!stack0.m_41619_() && !player.f_19853_.f_46443_ && ((Boolean)ConfigurationHandler.SPAWN.rage_mind_particles.get()).booleanValue()) {
                    ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, player.m_20185_(), player.m_20186_(), player.m_20189_(), ((int)NewCapabilities.SleepDataWrapper.getRage() / 100 - 1) / 2 - 1, 0.1, 0.1, 0.1, 0.01);
                }
            });
        }
    }

    @SubscribeEvent
    public void Tick(TickEvent.PlayerTickEvent event) {
        AABB targetBox;
        List foundTarget;
        ItemStack stack;
        Player player;
        Tick.Stats config = (Tick.Stats)Tick.INSTANCE.getConfig();
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer && !(stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.TICK.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && !(foundTarget = player.f_19853_.m_6443_(LivingEntity.class, targetBox = new AABB(player.m_20182_(), player.m_20182_()).m_82400_((double)config.rangeToActivate), EventHandler::isValidTarget)).isEmpty()) {
            for (LivingEntity livingEntity : foundTarget) {
                if (livingEntity.m_21233_() > 50.0f && livingEntity.m_21223_() > livingEntity.m_21233_() / 2.0f && player.m_21223_() >= 5.0f) {
                    livingEntity.m_6469_(DamageSource.f_19318_, livingEntity.m_21233_() * (config.entityDamagePercentage / 100.0f));
                    player.m_6469_(DamageSource.f_19318_, player.m_21233_() * (config.playerDamagePercentage / 100.0f));
                    continue;
                }
                if (!(livingEntity.m_21233_() > 50.0f) || !(livingEntity.m_21223_() > livingEntity.m_21233_() / 2.0f) || player.m_36324_().m_38702_() < 5) continue;
                livingEntity.m_6469_(DamageSource.f_19318_, livingEntity.m_21233_() * (config.entityDamagePercentage / 100.0f));
                player.m_36399_((float)player.m_36324_().m_38702_() * (config.playerHungerPercentage / 100.0f));
            }
        }
    }

    @SubscribeEvent
    public void Blindfold(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.BLINDFOLD.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!stack.m_41619_()) {
                player.m_6842_(true);
            } else if (stack.m_41619_()) {
                player.m_6842_(false);
            }
        }
    }

    @SubscribeEvent
    public void ExplosionProofJacket(LivingHurtEvent event) {
        ExplosionProofJacket.Stats config = (ExplosionProofJacket.Stats)ExplosionProofJacket.INSTANCE.getConfig();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getEntity() == player) {
                Level world = player.f_19853_;
                ItemStack itemStack = Items.f_41996_.m_7968_();
                ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.EXPLOSION_PROOF_JACKECT.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
                if (!stack0.m_41619_() && event.getSource().m_19372_()) {
                    event.setAmount(event.getAmount() * (1.0f - config.blastDamagePercentageReduction) * 100.0f);
                    BlockPos pos = player.m_20183_();
                    ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemStack);
                    itementity.m_32060_();
                    itementity.m_20331_(true);
                    world.m_7967_((Entity)itementity);
                }
            }
        }
    }

    @SubscribeEvent
    public void GhastEyeRegen(LivingDeathEvent event) {
        GhastEye.Stats config = (GhastEye.Stats)GhastEye.INSTANCE.getConfig();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.GHAST_EYE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!stack0.m_41619_()) {
                if (!player.m_21023_(MobEffects.f_19605_)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, config.regenerationTime, config.regenerationLevel));
                } else {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Objects.requireNonNull(player.m_21124_(MobEffects.f_19605_)).m_19557_() + config.regenerationExtraTime, config.regenerationLevel));
                }
            }
        }
    }

    @SubscribeEvent
    public void WoodenStick(LivingDamageEvent event) {
        WoodenStick.Stats config = (WoodenStick.Stats)WoodenStick.INSTANCE.getConfig();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WOODEN_STICK.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!(stack.m_41619_() || player.f_19853_.f_46443_ || player.m_36335_().m_41519_(stack.m_41720_()))) {
                event.setAmount(0.0f);
                player.m_36335_().m_41524_(stack.m_41720_(), config.cooldown);
            }
        }
    }

    @SubscribeEvent
    public void WoodenStickCD(TickEvent.PlayerTickEvent event) {
        Player player;
        WoodenStick.Stats config = (WoodenStick.Stats)WoodenStick.INSTANCE.getConfig();
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WOODEN_STICK.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
                if (NewCapabilities.SleepDataWrapper.getWoodenStick() != config.damageShield && player.m_36335_().m_41521_(stack.m_41720_(), 0.0f) == 0.0f) {
                    trinketsData.setWoodenStick(config.damageShield);
                }
            });
        }
    }

    @SubscribeEvent
    public void BlazeNucleus(LivingHurtEvent event) {
        ItemStack stack0;
        BlazeNucleus.Stats config = (BlazeNucleus.Stats)BlazeNucleus.INSTANCE.getConfig();
        DamageSource source = event.getSource();
        Entity src = source.m_7639_();
        if (src instanceof Player && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.BLAZE_NUCLEUS.get(), (LivingEntity)src).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_()) {
            LivingEntity entity = event.getEntity();
            entity.m_7311_(config.setEnemyInFireTicks);
        }
    }

    @SubscribeEvent
    public void BlazeNucleusImmune(LivingHurtEvent event) {
        BlazeNucleus.Stats config = (BlazeNucleus.Stats)BlazeNucleus.INSTANCE.getConfig();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            ItemStack stack0;
            Player player = (Player)livingEntity;
            if (event.getEntity() == player && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.BLAZE_NUCLEUS.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && config.fireDamageReductionPercentage < 100.0f && (event.getSource() == DamageSource.f_19308_ || event.getSource() == DamageSource.f_19307_ || event.getSource() == DamageSource.f_19305_ || event.getSource() == DamageSource.f_19309_)) {
                event.setAmount(event.getAmount() * (1.0f - config.fireDamageReductionPercentage / 100.0f));
            }
        }
    }

    @SubscribeEvent
    public void BlazeNucleusImmune2(LivingAttackEvent event) {
        BlazeNucleus.Stats config = (BlazeNucleus.Stats)BlazeNucleus.INSTANCE.getConfig();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            ItemStack stack0;
            Player player = (Player)livingEntity;
            if (!(event.getEntity() != player || (stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.BLAZE_NUCLEUS.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() || config.fireDamageReductionPercentage != 100.0f || event.getSource() != DamageSource.f_19308_ && event.getSource() != DamageSource.f_19307_ && event.getSource() != DamageSource.f_19305_ && event.getSource() != DamageSource.f_19309_)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void IceCube(LivingHurtEvent event) {
        ItemStack stack0;
        IceCube.Stats config = (IceCube.Stats)IceCube.INSTANCE.getConfig();
        DamageSource source = event.getSource();
        Entity src = source.m_7639_();
        if (src instanceof Player && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.ICE_CUBE.get(), (LivingEntity)src).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_()) {
            MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.f_19597_, config.slownessTime, config.slownessLevel);
            LivingEntity potionGo = event.getEntity();
            potionGo.m_7292_(effectinstance);
        }
    }

    @SubscribeEvent
    public void IceCubeGround(TickEvent.PlayerTickEvent event) {
        IceCube.Stats config = (IceCube.Stats)IceCube.INSTANCE.getConfig();
        if (event.phase == TickEvent.Phase.START) {
            ItemStack stack0;
            Player player = event.player;
            BlockPos pos = player.m_20183_();
            Level world = player.f_19853_;
            if (player instanceof ServerPlayer && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.ICE_CUBE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && !player.f_19853_.f_46443_) {
                BlockState block = Blocks.f_50126_.m_49966_();
                ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, 0.5, 1.0, 0.5, 0.1);
                if (player.m_20096_()) {
                    BlockState blockstate = Blocks.f_50449_.m_49966_();
                    float f = Math.min(16, 2 + config.frostWalkerLevel);
                    BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
                    for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), -1.0, (double)(-f)), (BlockPos)pos.m_7637_((double)f, -1.0, (double)f))) {
                        boolean isFull;
                        if (!blockpos.m_203195_((Position)player.m_20182_(), (double)f)) continue;
                        blockpos$mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
                        BlockState blockstate1 = world.m_8055_((BlockPos)blockpos$mutable);
                        if (!blockstate1.m_60795_()) continue;
                        BlockState blockstate2 = world.m_8055_(blockpos);
                        boolean bl = isFull = blockstate2.m_60734_() == Blocks.f_49990_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
                        if (blockstate2.m_60767_() != Material.f_76305_ || !isFull || !blockstate.m_60710_((LevelReader)world, blockpos) || !world.m_45752_(blockstate, blockpos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)blockpos), (Direction)Direction.UP)) continue;
                        world.m_46597_(blockpos, blockstate);
                        world.m_186460_(blockpos, Blocks.f_50449_, Mth.m_216271_((RandomSource)player.m_217043_(), (int)60, (int)120));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void SigilOfBaphometCount(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.SIGIL_OF_BAPHOMET.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (!stack0.m_41619_() && trinketsData.getSigil() <= 10.0f) {
                    trinketsData.setSigil(trinketsData.getSigil() + 1.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public void SigilOfBaphometTime(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.SIGIL_OF_BAPHOMET.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (!stack0.m_41619_() && trinketsData.getSigil() > 0.0f && trinketsData.getTick() >= 20.0f) {
                    trinketsData.setSigil(trinketsData.getSigil() - 1.0f);
                    trinketsData.setTick(0.0f);
                } else if (!stack0.m_41619_() && trinketsData.getSigil() > 0.0f) {
                    trinketsData.setTick(trinketsData.getTick() + 1.0f);
                } else if (stack0.m_41619_() && trinketsData.getTick() > 0.0f) {
                    trinketsData.setTick(0.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public void SigilOfBaphometImmunity(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getEntity() == player) {
                ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.SIGIL_OF_BAPHOMET.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
                NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                    if (!stack0.m_41619_() && trinketsData.getSigil() > 0.0f && !player.f_19853_.f_46443_) {
                        ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123809_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 0.5, 1.0, 0.5, 0.1);
                        event.setAmount(0.0f);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void CreeperSenseTime(TickEvent.PlayerTickEvent event) {
        Player player;
        CreeperSense.Stats config = (CreeperSense.Stats)CreeperSense.INSTANCE.getConfig();
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CREEPER_SENSE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (!stack0.m_41619_() && trinketsData.getCreeper() && trinketsData.getTickCreeper() >= 40.0f) {
                    Explosion.BlockInteraction explosion$mode = ForgeEventFactory.getMobGriefingEvent((Level)player.f_19853_, (Entity)player) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
                    player.f_19853_.m_46511_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), config.explosionLevel, explosion$mode);
                    trinketsData.setCreeper(false);
                    trinketsData.setTickCreeper(0.0f);
                    trinketsData.setTickCreeperPause(20.0f);
                } else if (!stack0.m_41619_() && trinketsData.getCreeper()) {
                    trinketsData.setTickCreeper(trinketsData.getTickCreeper() + 1.0f);
                } else if (stack0.m_41619_() && trinketsData.getTickCreeper() > 0.0f) {
                    trinketsData.setTickCreeper(0.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public void CreeperSenseTimePause(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CREEPER_SENSE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (!stack0.m_41619_() && trinketsData.getTickCreeperPause() <= 20.0f && trinketsData.getTickCreeperPause() >= 0.0f) {
                    trinketsData.setTickCreeperPause(trinketsData.getTickCreeperPause() - 1.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public void CreeperSense(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer && !(stack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CREEPER_SENSE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_()) {
            AABB targetBox = new AABB(player.m_20182_(), player.m_20182_()).m_82400_(5.0);
            List foundTarget = player.f_19853_.m_6443_(LivingEntity.class, targetBox, EventHandler::isValidTarget);
            NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                if (!foundTarget.isEmpty() && trinketsData.getTickCreeperPause() <= 0.0f) {
                    trinketsData.setCreeper(true);
                }
            });
        }
    }

    @SubscribeEvent
    public void Fertilizer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemStack stack0;
            Player player = event.player;
            Level world = player.f_19853_;
            Random random = new Random();
            float rx = random.nextFloat() * 5.0f - 3.0f;
            float rz = random.nextFloat() * 5.0f - 3.0f;
            float ry = random.nextFloat() * 2.0f - 2.0f;
            float ry0 = random.nextFloat() * 2.0f;
            if (player instanceof ServerPlayer && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.FERTILIZER.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && !player.f_19853_.f_46443_) {
                ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, 0.5, 1.0, 0.5, 0.1);
                BlockPos posBelow = player.m_20183_().m_7495_();
                BlockState blockStateBelow = player.f_19853_.m_8055_(posBelow);
                Block below = blockStateBelow.m_60734_();
                if (below == Blocks.f_50440_) {
                    BonemealableBlock igrowable;
                    Block block;
                    BlockState blockstate;
                    BlockPos pos = new BlockPos((double)((float)player.m_20183_().m_123341_() + rx), (double)((float)player.m_20183_().m_123342_() + ry), (double)((float)player.m_20183_().m_123343_() + rz));
                    int hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)world, (BlockPos)pos, (BlockState)(blockstate = world.m_8055_(pos)), (ItemStack)stack0);
                    if (hook == 0 && (block = blockstate.m_60734_()) instanceof BonemealableBlock && (igrowable = (BonemealableBlock)block).m_7370_((BlockGetter)world, pos, blockstate, world.f_46443_) && world instanceof ServerLevel && igrowable.m_214167_(world, world.f_46441_, pos, blockstate)) {
                        igrowable.m_214148_((ServerLevel)world, world.f_46441_, pos, blockstate);
                    }
                } else {
                    BonemealableBlock igrowable;
                    Block block;
                    BlockState blockstate;
                    BlockPos pos = new BlockPos((double)((float)player.m_20183_().m_123341_() + rx), (double)((float)player.m_20183_().m_123342_() + ry0), (double)((float)player.m_20183_().m_123343_() + rz));
                    int hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)world, (BlockPos)pos, (BlockState)(blockstate = world.m_8055_(pos)), (ItemStack)stack0);
                    if (hook == 0 && (block = blockstate.m_60734_()) instanceof BonemealableBlock && (igrowable = (BonemealableBlock)block).m_7370_((BlockGetter)world, pos, blockstate, world.f_46443_) && world instanceof ServerLevel && igrowable.m_214167_(world, world.f_46441_, pos, blockstate)) {
                        igrowable.m_214148_((ServerLevel)world, world.f_46441_, pos, blockstate);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void MoonStoneDamage(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            ItemStack stack0;
            Player player = (Player)livingEntity;
            if (event.getEntity() == player && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.MOON_STONE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && event.getSource() == DamageSource.f_19315_) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void LuckyHorseshoe(EntityMountEvent event) {
        LuckyHorseshoe.Stats config = (LuckyHorseshoe.Stats)LuckyHorseshoe.INSTANCE.getConfig();
        Entity entity = event.getEntityMounting();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity = event.getEntityBeingMounted();
            if (entity instanceof AbstractHorse) {
                AbstractHorse horseEntity = (AbstractHorse)entity;
                ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.LUCKY_HORSESHOE.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
                if (!stack0.m_41619_()) {
                    horseEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, config.horseRegenerationTime, config.horseRegenerationLevel));
                }
            }
        }
    }

    @SubscribeEvent
    public void SleepingPills(TickEvent.PlayerTickEvent event) {
        ItemStack stack0;
        Player player;
        SleepingPills.Stats config = (SleepingPills.Stats)SleepingPills.INSTANCE.getConfig();
        if (event.phase == TickEvent.Phase.START && (player = event.player) != null && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.SLEEPING_PILLS.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_()) {
            List list;
            if (!player.m_21023_(MobEffects.f_19611_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, config.nightVisionTime, 0, false, false));
            }
            if (!(list = player.f_19853_.m_6443_(Phantom.class, player.m_20191_().m_82400_(config.phantomRange), EntitySelector.f_20402_)).isEmpty()) {
                for (Phantom phantomEntity : list) {
                    phantomEntity.m_20334_(0.0, 20.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void SleepingPills(PlayerSleepInBedEvent event) {
        ItemStack stack0;
        SleepingPills.Stats config = (SleepingPills.Stats)SleepingPills.INSTANCE.getConfig();
        Player player = event.getEntity();
        if (player != null && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.SLEEPING_PILLS.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && config.bedDisabled) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public void AmphibiousHands(PlayerEvent.BreakSpeed event) {
        AmphibiousHands.Stats config = (AmphibiousHands.Stats)AmphibiousHands.INSTANCE.getConfig();
        TrueHeartOfTheSea.Stats config0 = (TrueHeartOfTheSea.Stats)TrueHeartOfTheSea.INSTANCE.getConfig();
        if (event.getEntity() != null) {
            Player player = event.getEntity();
            ItemStack stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.AMPHIBIOUS_HANDS.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            ItemStack stack1 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.TRUE_HEART_OF_THE_SEA.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_);
            if (!stack0.m_41619_() && player.m_204029_(FluidTags.f_13131_)) {
                event.setNewSpeed(event.getOriginalSpeed() * config.miningUnderwaterSpeedMultiplier);
            }
            if (!stack1.m_41619_() && player.m_204029_(FluidTags.f_13131_)) {
                event.setNewSpeed(event.getOriginalSpeed() * config0.miningUnderwaterSpeed);
            }
        }
    }

    @SubscribeEvent
    public void SpiderLegs(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemStack stack0;
            SpiderLegs.Stats config = (SpiderLegs.Stats)SpiderLegs.INSTANCE.getConfig();
            Player player = event.player;
            if (player != null && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.SPIDER_LEGS.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_() && player.f_19862_) {
                Vec3 motion = player.m_20184_();
                player.m_20334_(motion.f_82479_, (double)config.climbSpeed, motion.f_82481_);
            }
        }
    }

    @SubscribeEvent
    public void Reforger(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemStack stack0;
            Reforger.Stats config = (Reforger.Stats)Reforger.INSTANCE.getConfig();
            Player player = event.player;
            if (player != null && !(stack0 = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.REFORGER.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.f_41583_)).m_41619_()) {
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    ItemStack itemstack;
                    if (!player.m_150109_().m_8020_(i).m_41768_() || (itemstack = player.m_150109_().m_8020_(i)) == null || event.player.f_19797_ % (config.repairSpeedSeconds * 20) != 0) continue;
                    int x = Math.min((int)((float)config.repairCuantity * itemstack.getXpRepairRatio()), itemstack.m_41773_());
                    itemstack.m_41721_(itemstack.m_41773_() - x);
                }
            }
        }
    }

    @SubscribeEvent
    public void EnchantmentBlockRightClick(PlayerInteractEvent.LeftClickBlock event) {
        block5: {
            Player player = event.getEntity();
            if (player == null || !((Boolean)ConfigurationHandler.SPAWN.get_fragments.get()).booleanValue()) break block5;
            Item itemstack = (Item)ModItems.UNKNOWN_FRAGMENT.get();
            Level level = player.f_19853_;
            Random random = new Random();
            if (!level.f_46443_ && (event.getLevel().m_8055_(event.getPos()) == Blocks.f_50201_.m_49966_() || event.getLevel().m_8055_(event.getPos()).toString().contains("matrix_enchanter"))) {
                if (ModList.get().isLoaded("expandability")) {
                    List<TrinketItem<?>> trinketItems0 = ModItems.getTrinketsReg();
                    List<TrinketItem<?>> trinketItems1 = ModItemsExpand.getTrinketsRegExpand();
                    List trinketItems = Stream.concat(trinketItems0.stream(), trinketItems1.stream()).collect(Collectors.toList());
                    for (int i = 0; i < trinketItems.size(); ++i) {
                        TrinketItem trinketItem = (TrinketItem)((Object)trinketItems.get(random.nextInt(trinketItems.size())));
                        if (!player.m_21205_().toString().contains(trinketItem.toString())) continue;
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.m_217043_().m_188501_() * 0.4f + 0.8f));
                        ItemStack itemstack1 = player.m_21120_(player.m_7655_());
                        itemstack1.m_41774_(1);
                        BlockPos pos = player.m_20183_();
                        ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123809_, (double)event.getPos().m_123341_() + 0.5, (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_() + 0.5, 200, 1.0, 1.0, 1.0, 0.1);
                        ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_175827_, (double)event.getPos().m_123341_() + 0.5, (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_() + 0.5, 100, 1.0, 1.0, 1.0, 0.1);
                        ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), itemstack.m_7968_());
                        itementity.m_32060_();
                        level.m_7967_((Entity)itementity);
                    }
                } else {
                    List<TrinketItem<?>> trinketItems = ModItems.getTrinketsReg();
                    for (int i = 0; i < trinketItems.size(); ++i) {
                        TrinketItem<?> trinketItem = trinketItems.get(random.nextInt(trinketItems.size()));
                        if (!player.m_21205_().toString().contains(trinketItem.toString())) continue;
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.m_217043_().m_188501_() * 0.4f + 0.8f));
                        ItemStack itemstack1 = player.m_21120_(player.m_7655_());
                        itemstack1.m_41774_(1);
                        BlockPos pos = player.m_20183_();
                        ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123809_, (double)event.getPos().m_123341_() + 0.5, (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_() + 0.5, 200, 1.0, 1.0, 1.0, 0.1);
                        ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_175827_, (double)event.getPos().m_123341_() + 0.5, (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_() + 0.5, 100, 1.0, 1.0, 1.0, 0.1);
                        ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), itemstack.m_7968_());
                        itementity.m_32060_();
                        level.m_7967_((Entity)itementity);
                    }
                }
            }
        }
    }
}

