/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.utils;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.init.ModItemsExpand;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketLoot;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class DungeonLootModifier
extends LootModifier {
    public static final Supplier<Codec<DungeonLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DungeonLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DungeonLootModifier::new)));

    public DungeonLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (ModList.get().isLoaded("expandability")) {
            RandomSource random = context.m_230907_();
            List<TrinketItem<?>> trinketItems0 = ModItems.getTrinketsReg();
            List<TrinketItem<?>> trinketItems1 = ModItemsExpand.getTrinketsRegExpand();
            List trinketItems = Stream.concat(trinketItems0.stream(), trinketItems1.stream()).collect(Collectors.toList());
            for (int i = 0; i < trinketItems.size(); ++i) {
                TrinketItem trinketItem = (TrinketItem)((Object)trinketItems.get(random.m_188503_(trinketItems.size())));
                int generated = 0;
                for (TrinketLoot trinketLoot : trinketItem.getData().getLoot()) {
                    if (!trinketLoot.getTable().contains(context.getQueriedLootTableId().toString()) || !(random.m_188501_() <= trinketLoot.getChance())) continue;
                    generatedLoot.add((Object)new ItemStack((ItemLike)trinketItem));
                    ++generated;
                }
                if (generated >= 1) break;
            }
            return generatedLoot;
        }
        RandomSource random = context.m_230907_();
        List<TrinketItem<?>> trinketItems = ModItems.getTrinketsReg();
        for (int i = 0; i < trinketItems.size(); ++i) {
            TrinketItem<?> trinketItem = trinketItems.get(random.m_188503_(trinketItems.size()));
            int generated = 0;
            for (TrinketLoot trinketLoot : trinketItem.getData().getLoot()) {
                if (!trinketLoot.getTable().contains(context.getQueriedLootTableId().toString()) || !(random.m_188501_() <= trinketLoot.getChance())) continue;
                generatedLoot.add((Object)new ItemStack(trinketItem));
                ++generated;
            }
            if (generated >= 1) break;
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

