/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.utils;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketLoot;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DungeonLootModifier
extends LootModifier {
    public DungeonLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Random random = context.m_78933_();
        List<TrinketItem<?>> trinketItems = ModItems.getTrinketsReg();
        for (int i = 0; i < trinketItems.size(); ++i) {
            TrinketItem<?> trinketItem = trinketItems.get(random.nextInt(trinketItems.size()));
            int generated = 0;
            for (TrinketLoot trinketLoot : trinketItem.getData().getLoot()) {
                if (!trinketLoot.getTable().contains(context.getQueriedLootTableId().toString()) || !(random.nextFloat() <= trinketLoot.getChance())) continue;
                generatedLoot.add(new ItemStack(trinketItem));
                ++generated;
            }
            if (generated >= 1) break;
        }
        return generatedLoot;
    }

    @Mod.EventBusSubscriber(modid="nameless_trinkets", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandler {
        @SubscribeEvent
        public static void registerModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName(new ResourceLocation("nameless_trinkets", "dungeon_loot_modifier")));
        }
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<DungeonLootModifier> {
        private Serializer() {
        }

        public DungeonLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            return new DungeonLootModifier(ailootcondition);
        }

        public JsonObject write(DungeonLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

