/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.utils;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class EntityUtils {
    private static String getAttributeName(ItemStack stack, Attribute attribute) {
        return stack.m_41720_().getRegistryName().m_135815_() + "_" + attribute.getRegistryName().m_135815_();
    }

    public static boolean applyAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, float value, AttributeModifier.Operation operation) {
        String name = EntityUtils.getAttributeName(stack, attribute);
        if (name.equals("")) {
            return false;
        }
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        AttributeModifier modifier = new AttributeModifier(uuid, name, (double)value, operation);
        if (instance == null || instance.m_22109_(modifier)) {
            return false;
        }
        instance.m_22118_(modifier);
        return true;
    }

    public static boolean removeAttribute(LivingEntity entity, ItemStack stack, Attribute attribute, float value, AttributeModifier.Operation operation) {
        String name = EntityUtils.getAttributeName(stack, attribute);
        if (name.equals("")) {
            return false;
        }
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        AttributeModifier modifier = new AttributeModifier(uuid, name, (double)value, operation);
        if (instance == null || !instance.m_22109_(modifier)) {
            return false;
        }
        instance.m_22130_(modifier);
        return true;
    }

    public static void applyAttributeModifier(AttributeInstance instance, AttributeModifier modifier) {
        if (!instance.m_22109_(modifier)) {
            instance.m_22118_(modifier);
        }
    }

    public static void removeAttributeModifier(AttributeInstance instance, AttributeModifier modifier) {
        if (instance.m_22109_(modifier)) {
            instance.m_22130_(modifier);
        }
    }
}

