/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.events;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.orcinus.overweightfarming.init.OFBlocks;
import net.orcinus.overweightfarming.init.OFItems;
import net.orcinus.overweightfarming.util.OverweightGrowthManager;

@Mod.EventBusSubscriber(modid="overweight_farming", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiscEvents {
    public static final Supplier<BiMap<Block, Block>> WAXABLES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)OFBlocks.SEEDED_PEELED_MELON.get()), (Object)((Block)OFBlocks.WAXED_SEEDED_PEELED_MELON.get())).put((Object)((Block)OFBlocks.HALF_SEEDED_PEELED_MELON.get()), (Object)((Block)OFBlocks.WAXED_HALF_SEEDED_PEELED_MELON.get())).put((Object)((Block)OFBlocks.SEEDLESS_PEELED_MELON.get()), (Object)((Block)OFBlocks.WAXED_SEEDLESS_PEELED_MELON.get())).build());
    public static final Supplier<BiMap<Block, Block>> WAX_OFF_BY_BLOCK = Suppliers.memoize(() -> WAXABLES.get().inverse());
    public static final Supplier<BiMap<Block, Block>> PEELABLES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)OFBlocks.OVERWEIGHT_BEETROOT.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_BEETROOT.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_CARROT.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_CARROT.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_POTATO.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_POTATO.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_ONION.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_ONION.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_KIWI.get()), (Object)((Block)OFBlocks.OVERWEIGHT_SLICED_KIWI.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_SLICED_KIWI.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_KIWI.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_GINGER.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_GINGER.get())).put((Object)((Block)OFBlocks.OVERWEIGHT_COCOA.get()), (Object)((Block)OFBlocks.PEELED_OVERWEIGHT_COCOA.get())).put((Object)Blocks.f_50186_, (Object)((Block)OFBlocks.SEEDED_PEELED_MELON.get())).build());
    public static final Supplier<BiMap<Block, Block>> UNPEELABLES = Suppliers.memoize(() -> PEELABLES.get().inverse());

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer serverPlayer;
        ItemStack stack = event.getItemStack();
        Level world = event.getLevel();
        BlockPos blockPos = event.getPos();
        BlockState state = world.m_8055_(blockPos);
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (stack.m_41720_() instanceof AxeItem) {
            for (Block block : WAX_OFF_BY_BLOCK.get().keySet()) {
                if (!state.m_60713_(block)) continue;
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, blockPos, stack);
                }
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                world.m_5594_(null, blockPos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_46597_(blockPos, ((Block)WAX_OFF_BY_BLOCK.get().get((Object)block)).m_49966_());
                world.m_5898_(player, 3004, blockPos, 0);
                player.m_6674_(hand);
            }
            for (Block block : PEELABLES.get().keySet()) {
                if (!state.m_60713_(block)) continue;
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, blockPos, stack);
                }
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                world.m_5594_(null, blockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                Block.m_49840_((Level)world, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)OFItems.VEGETABLE_PEELS.get()));
                world.m_46597_(blockPos, ((Block)PEELABLES.get().get((Object)block)).m_49966_());
                player.m_6674_(hand);
            }
        }
        if (stack.m_41720_() == Items.f_42784_) {
            for (Block block : WAXABLES.get().keySet()) {
                if (!state.m_60713_(block)) continue;
                event.setCanceled(true);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, blockPos, stack);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                world.m_5594_(null, blockPos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_46597_(blockPos, ((Block)WAXABLES.get().get((Object)block)).m_49966_());
                world.m_5898_(player, 3003, blockPos, 0);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)world.f_46443_));
            }
        }
        if (stack.m_41720_() == OFItems.VEGETABLE_PEELS.get()) {
            for (Block block : UNPEELABLES.get().keySet()) {
                if (!state.m_60713_(block)) continue;
                event.setCanceled(true);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, blockPos, stack);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                world.m_5594_(null, blockPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                BlockState blockState = ((Block)UNPEELABLES.get().get((Object)block)).m_49966_();
                world.m_46597_(blockPos, blockState);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)world.f_46443_));
            }
        }
    }

    @SubscribeEvent
    public void onCropsGrow(BlockEvent.CropGrowEvent.Pre event) {
        LevelAccessor level = event.getLevel();
        BlockPos blockPos = event.getPos();
        BlockState state = event.getState();
        RandomSource random = level.m_213780_();
        OverweightGrowthManager manager = new OverweightGrowthManager(random);
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            for (Block cropBlock : manager.getOverweightMap().keySet()) {
                float chance;
                boolean flag3;
                if (!state.m_60713_(cropBlock)) continue;
                boolean flag = state.m_61138_((Property)CropBlock.f_52244_) && (Integer)state.m_61143_((Property)CropBlock.f_52244_) < 7 && (Integer)state.m_61143_((Property)CropBlock.f_52244_) == 3;
                boolean flag1 = state.m_61138_((Property)CocoaBlock.f_51736_) && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) == 1;
                boolean flag2 = (state.m_60734_() instanceof BeetrootBlock || state.m_60734_() instanceof NetherWartBlock) && state.m_61138_((Property)BlockStateProperties.f_61407_) && (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_) < 3 && (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_) > 1;
                boolean bl = flag3 = ModList.get().isLoaded("hedgehog") && state.m_60734_() == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("hedgehog", "kiwi_vines")) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_155977_) != false;
                if (!flag && !flag1 && !flag2 && !flag3) continue;
                float f = chance = world.m_46462_() && world.m_46941_() == 0 ? 0.0010538863f : 3.4290552E-4f;
                if (!(random.m_188501_() < chance)) continue;
                event.setResult(Event.Result.DENY);
                manager.growOverweightCrops(world, blockPos, state, random);
            }
        }
    }
}

