/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.events;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.orcinus.overweightfarming.init.OFItems;
import net.orcinus.overweightfarming.util.OFItemsForEmeralds;
import net.orcinus.overweightfarming.util.OverweightGrowthManager;

@Mod.EventBusSubscriber(modid="overweight_farming", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEvents {
    @SubscribeEvent
    public void onVillagerTradesInit(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        if (profession == VillagerProfession.f_35590_) {
            OFItemsForEmeralds hatTrade = new OFItemsForEmeralds((Item)OFItems.STRAW_HAT.get(), 20, 1, 4);
            Int2ObjectMap map = event.getTrades();
            List list = (List)event.getTrades().get(5);
            list.add(hatTrade);
            map.put(5, (Object)list);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.m_21120_(hand);
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (stack.m_41720_() == OFItems.VEGETABLE_PEELS.get()) {
                int i = pig.m_146764_();
                if (!pig.f_19853_.f_46443_ && i == 0 && pig.m_5957_()) {
                    event.setCanceled(true);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    pig.m_27595_(player);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
                if (pig.m_6162_()) {
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    pig.m_146740_((int)((float)(-i / 20) * 0.1f), true);
                    player.m_6674_(hand);
                }
                if (pig.f_19853_.f_46443_) {
                    event.setCancellationResult(InteractionResult.CONSUME);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            pig.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)pig, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OFItems.VEGETABLE_PEELS.get()}), false));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.f_19853_;
        if (!world.m_5776_() && entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)OFItems.STRAW_HAT.get())) {
            int radius = 40;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        boolean asda;
                        boolean hedgehogFlag;
                        BlockPos entityPosition = entity.m_20183_();
                        BlockPos cropPos = new BlockPos(entityPosition.m_123341_() + x, entityPosition.m_123342_() + y, entityPosition.m_123343_() + z);
                        BlockState state = world.m_8055_(cropPos);
                        String hedgehogModid = "hedgehog";
                        Block kiwiVines = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(hedgehogModid, "kiwi_vines"));
                        boolean bl = hedgehogFlag = ModList.get().isLoaded(hedgehogModid) && state.m_60713_(Objects.requireNonNull(kiwiVines));
                        if (!state.m_204336_(BlockTags.f_13073_) && !hedgehogFlag && !(state.m_60734_() instanceof NetherWartBlock)) continue;
                        Block block = state.m_60734_();
                        float v = world.m_213780_().m_188501_();
                        boolean flag = (double)v < 1.6540289E-4 && world.m_213780_().m_188499_();
                        boolean validForOverweight = false;
                        if (!(world instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)world;
                        if (!flag) continue;
                        if (block == kiwiVines && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_155977_)).booleanValue()) {
                            validForOverweight = true;
                        }
                        if (state.m_61138_((Property)CropBlock.f_52244_)) {
                            int age;
                            if (block instanceof CropBlock) {
                                CropBlock crop = (CropBlock)block;
                                int age2 = (Integer)state.m_61143_((Property)CropBlock.f_52244_);
                                if (age2 < crop.m_7419_()) {
                                    crop.m_52263_((Level)serverLevel, cropPos, state);
                                }
                                if (age2 == crop.m_7419_()) {
                                    validForOverweight = true;
                                }
                            } else if (block instanceof StemBlock && (age = ((Integer)state.m_61143_((Property)StemBlock.f_57013_)).intValue()) < 7) {
                                serverLevel.m_7731_(cropPos, (BlockState)state.m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(age + 1)), 2);
                            }
                        }
                        if (asda = state.m_61138_((Property)BlockStateProperties.f_61407_)) {
                            if (block instanceof BeetrootBlock) {
                                BeetrootBlock beetrootBlock = (BeetrootBlock)block;
                                int age = (Integer)state.m_61143_((Property)BeetrootBlock.f_49657_);
                                if (age < beetrootBlock.m_7419_()) {
                                    beetrootBlock.m_52263_((Level)serverLevel, cropPos, state);
                                }
                                if (age == beetrootBlock.m_7419_()) {
                                    validForOverweight = true;
                                }
                            }
                            if (block instanceof NetherWartBlock) {
                                int age = (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_);
                                if (age < 3) {
                                    world.m_7731_(cropPos, (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) + 1)), 2);
                                }
                                if (age == 3) {
                                    validForOverweight = true;
                                }
                            }
                        }
                        OverweightGrowthManager manager = new OverweightGrowthManager(world.m_213780_());
                        if (!validForOverweight) continue;
                        for (Block overgrowth : manager.getOverweightMap().keySet()) {
                            if (!state.m_60713_(overgrowth)) continue;
                            manager.growOverweightCrops(serverLevel, cropPos, state, serverLevel.m_213780_());
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onBabySpawn(BabyEntitySpawnEvent event) {
        Level world;
        AgeableMob mob = event.getChild();
        Mob mobA = event.getParentA();
        Mob mobB = event.getParentB();
        Player player = event.getCausedByPlayer();
        if (player != null && player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)OFItems.STRAW_HAT.get()) && mob instanceof Animal && (world = mob.m_9236_()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            if (mobA instanceof Animal) {
                Animal animalParentA = (Animal)mobA;
                if (mobB instanceof Animal) {
                    Animal animalParentB = (Animal)mobB;
                    RandomSource random = world.m_213780_();
                    int tries = 0;
                    if (random.m_188503_(3) == 0) {
                        ++tries;
                        if (random.m_188503_(12) == 0) {
                            ++tries;
                        }
                    }
                    for (int i = 0; i < tries; ++i) {
                        AgeableMob newChild = animalParentA.m_142606_(level, (AgeableMob)animalParentB);
                        if (newChild == null) continue;
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            serverPlayer.m_36220_(Stats.f_12937_);
                            CriteriaTriggers.f_10581_.m_147278_(serverPlayer, animalParentA, animalParentB, newChild);
                        }
                        newChild.m_6863_(true);
                        newChild.m_7678_(animalParentA.m_20185_(), animalParentA.m_20186_(), animalParentA.m_20189_(), 0.0f, 0.0f);
                        level.m_47205_((Entity)newChild);
                    }
                }
            }
        }
    }
}

