/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.items;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.orcinus.overweightfarming.client.models.StrawHatModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrawHatItem
extends ArmorItem {
    public static final StrawHatMaterial MATERIAL = new StrawHatMaterial();
    private static final ResourceLocation TEXTURE = new ResourceLocation("overweight_farming", "textures/entity/straw_hat/straw_hat.png");
    private static final ResourceLocation TRANS_TEXTURE = new ResourceLocation("overweight_farming", "textures/entity/straw_hat/trans_rights.png");
    private static final ResourceLocation STRAW_TEXTURE = new ResourceLocation("overweight_farming", "textures/entity/straw_hat/straw_hat_straw.png");
    private static final ResourceLocation TEXTURE_420 = new ResourceLocation("overweight_farming", "textures/entity/straw_hat/420.png");
    public static final LinkedList<String> LISTS = (LinkedList)Util.m_137469_((Object)Lists.newLinkedList(), list -> {
        list.add("accessible_knowledge");
        list.add("amogus");
        list.add("atroxic");
        list.add("birb");
        list.add("black_hat");
        list.add("convenient_cauldron");
        list.add("delightful");
        list.add("doset");
        list.add("electrum_hat");
        list.add("frog_tongue");
        list.add("froggy_straw_hat");
        list.add("lead_hat");
        list.add("leadly_hat");
        list.add("pebble_hat");
        list.add("pirates");
        list.add("potat");
        list.add("silver_hat");
        list.add("there_is_a_frog_on_your_head_yknow");
    });

    public StrawHatItem(EquipmentSlot slot, Item.Properties properties) {
        super((ArmorMaterial)MATERIAL, slot, properties);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        for (String id : LISTS) {
            String namingContent = id.replace('_', ' ');
            if (!StrawHatItem.getContents(stack).equals(namingContent)) continue;
            return StrawHatItem.getContents(stack).equals(namingContent) ? new ResourceLocation("overweight_farming", "textures/entity/straw_hat/" + id + ".png").toString() : TEXTURE.toString();
        }
        return StrawHatItem.is420(stack) ? TEXTURE_420.toString() : (StrawHatItem.isStraw(stack) ? STRAW_TEXTURE.toString() : (StrawHatItem.isTrans(stack) ? TRANS_TEXTURE.toString() : TEXTURE.toString()));
    }

    public static boolean is420(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("420");
    }

    public static boolean isStraw(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("Straw");
    }

    public static boolean isTrans(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("Trans Rights");
    }

    @NotNull
    private static String getContents(ItemStack stack) {
        return stack.m_41786_().getString();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return new StrawHatModel(StrawHatModel.createBodyLayer().m_171564_());
            }
        });
    }

    private static class StrawHatMaterial
    implements ArmorMaterial {
        private StrawHatMaterial() {
        }

        public int m_7366_(EquipmentSlot slot) {
            return 5;
        }

        public int m_7365_(EquipmentSlot slot) {
            return 1;
        }

        public int m_6646_() {
            return 0;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_});
        }

        public String m_6082_() {
            return "straw";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

