/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import software.bernie.geckolib3.GeckoLib;
import tech.thatgravyboat.playdate.client.PlayDateClient;
import tech.thatgravyboat.playdate.common.blocks.ModBlockEntities;
import tech.thatgravyboat.playdate.common.blocks.ModBlocks;
import tech.thatgravyboat.playdate.common.containers.ModContainers;
import tech.thatgravyboat.playdate.common.entity.ModEntities;
import tech.thatgravyboat.playdate.common.entity.ToyEntity;
import tech.thatgravyboat.playdate.common.item.ModItems;
import tech.thatgravyboat.playdate.common.paintings.ModPaintings;
import tech.thatgravyboat.playdate.common.recipes.ModRecipes;
import tech.thatgravyboat.playdate.mixin.ItemAccessor;

@Mod(value="playdate")
public class PlayDate {
    public static final String MODID = "playdate";

    public PlayDate() {
        GeckoLib.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(PlayDate::addEntityAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(PlayDateClient::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(PlayDateClient::onItemColors));
        MinecraftForge.EVENT_BUS.addListener(PlayDate::onItemuse);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModRecipes.RECIPE_SERIALIZERS.register(bus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(bus);
        ModBlocks.BLOCKS.register(bus);
        ModItems.ITEMS.register(bus);
        ModEntities.ENTITY_TYPES.register(bus);
        ModContainers.MENUS.register(bus);
        ModPaintings.PAINTINGS.register(bus);
    }

    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.LOLLIPOP_CLOWN.get(), ToyEntity.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.4).m_22265_());
        event.put((EntityType)ModEntities.HAPPY_SUN.get(), ToyEntity.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.4).m_22265_());
        event.put((EntityType)ModEntities.PETUNIA_PIG.get(), ToyEntity.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.4).m_22265_());
    }

    public static void onItemuse(PlayerInteractEvent.RightClickItem event) {
        BlockHitResult blockHit;
        BlockPos blockPos;
        Level world;
        BlockHitResult hit;
        ItemStack stack = event.getItemStack();
        if (stack.m_150930_(Items.f_42590_) && (hit = ItemAccessor.invokeGetPlayerPOVHitResult(world = event.getWorld(), event.getPlayer(), ClipContext.Fluid.SOURCE_ONLY)).m_6662_().equals((Object)HitResult.Type.BLOCK) && hit instanceof BlockHitResult && world.m_8055_(blockPos = (blockHit = hit).m_82425_()).m_60713_(Blocks.f_50135_)) {
            world.m_5594_(event.getPlayer(), blockPos, SoundEvents.f_12394_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            world.m_46597_(blockPos, Blocks.f_50136_.m_49966_());
            world.m_5594_(event.getPlayer(), blockPos, SoundEvents.f_12219_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            event.getPlayer().m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            event.getPlayer().m_21008_(event.getHand(), ItemUtils.m_41813_((ItemStack)stack, (Player)event.getPlayer(), (ItemStack)new ItemStack((ItemLike)ModItems.BOTTLED_SOUL.get())));
            event.setCancellationResult(InteractionResult.m_19078_((boolean)world.f_46443_));
            event.setCanceled(true);
        }
    }

    public static ResourceLocation modId(String path) {
        return new ResourceLocation(MODID, path);
    }
}

