/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.playdate.common.blocks.ToyBlock;
import tech.thatgravyboat.playdate.common.constants.PlushieItem;

public class ToyBlockEntity
extends BlockEntity
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final PlushieItem plushie;

    public ToyBlockEntity(PlushieItem plushie, BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.plushie = plushie;
    }

    public PlushieItem getPlushie() {
        return this.plushie;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EntityType<?> creator) {
        ServerLevel server;
        if (level instanceof ServerLevel && (server = (ServerLevel)level).m_46462_() && ((Boolean)state.m_61143_((Property)ToyBlock.POSSESSED)).booleanValue()) {
            level.m_7471_(pos, false);
            Entity spawn = creator.m_20655_(server, null, null, null, pos, MobSpawnType.NATURAL, false, false);
            if (spawn != null) {
                Direction direction = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                spawn.m_146922_(direction.m_122435_());
                level.m_7967_(spawn);
            }
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

