/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.playdate.common.constants.BalloonType;
import tech.thatgravyboat.playdate.common.entity.ModEntities;

public class BalloonEntity
extends Entity
implements IAnimatable {
    private static final EntityDataAccessor<BalloonType> TEXTURE = SynchedEntityData.m_135353_(BalloonEntity.class, ModEntities.BALLOON_TYPE);
    private static final EntityDataAccessor<Boolean> RAINBOW = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HOLDER_ID = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> ROPE_LENGTH = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private Entity holder;
    private CompoundTag rope;

    public BalloonEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        if (this.rope != null) {
            this.readRopeData();
        }
        if (this.rope == null) {
            double distance;
            if (!(this.holder == null || this.holder.m_6084_() && this.m_6084_())) {
                this.detachRope();
            }
            if (this.holder != null && (distance = this.distanceToHolder()) < (double)(this.getRopeLength() + 2.0f)) {
                Vec3 multiply = this.holder.m_146892_().m_82546_(this.m_20182_()).m_82541_().m_82490_(distance * 0.1);
                this.m_20334_(multiply.f_82479_, 0.0, multiply.f_82481_);
            }
            if (this.holder == null || this.distanceToHolder() < (double)this.getRopeLength() || this.distanceToHolder() > (double)(this.getRopeLength() + 2.0f)) {
                Vec3 deltaMovement = this.m_20184_();
                this.m_20334_(deltaMovement.f_82479_, Mth.m_14008_((double)(deltaMovement.f_82480_ * (double)1.08f), (double)0.01f, (double)0.15f), deltaMovement.f_82481_);
            }
            double x = (double)(Mth.m_14089_((float)(this.f_19797_ + this.m_142049_() * 5 % 189503)) / 160.0f) * Math.PI;
            double z = (double)(Mth.m_14031_((float)(this.f_19797_ + this.m_142049_() * 5 % 189503)) / 160.0f) * Math.PI;
            this.m_5997_(x, 0.0, z);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.holder != null && this.distanceToHolder() > (double)(this.getRopeLength() + 2.0f)) {
                this.detachRope();
            }
            if (this.f_19853_.m_151570_(this.m_142538_())) {
                this.pop();
            }
        }
    }

    private double distanceToHolder() {
        if (this.holder == null) {
            return 0.0;
        }
        return Math.sqrt(this.m_20238_(this.holder.m_146892_()));
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_6084_()) {
            if (this.getHolder() == null) {
                this.attachRope((Entity)player);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.getHolder() == player) {
                this.detachRope();
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return super.m_6096_(player, hand);
    }

    private void pop() {
        this.m_146870_();
        for (int i = 0; i < 10; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_19387_()) {
            return false;
        }
        this.pop();
        return true;
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TEXTURE, (Object)BalloonType.COLORED);
        this.f_19804_.m_135372_(COLOR, (Object)-1);
        this.f_19804_.m_135372_(RAINBOW, (Object)false);
        this.f_19804_.m_135372_(HOLDER_ID, (Object)0);
        this.f_19804_.m_135372_(ROPE_LENGTH, (Object)Float.valueOf(2.0f));
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> data) {
        Entity holder;
        super.m_7350_(data);
        if (HOLDER_ID.equals(data) && this.f_19853_.f_46443_ && (holder = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(HOLDER_ID)).intValue())) != null) {
            this.holder = holder;
        }
    }

    public float getRopeLength() {
        return ((Float)this.f_19804_.m_135370_(ROPE_LENGTH)).floatValue();
    }

    public void setRopeLength(float value) {
        this.f_19804_.m_135381_(ROPE_LENGTH, (Object)Float.valueOf(value));
    }

    public boolean isRainbow() {
        return (Boolean)this.f_19804_.m_135370_(RAINBOW);
    }

    public void setRainbow(boolean value) {
        this.f_19804_.m_135381_(RAINBOW, (Object)value);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setColor(int value) {
        this.f_19804_.m_135381_(COLOR, (Object)value);
    }

    public BalloonType getTexture() {
        return (BalloonType)((Object)this.f_19804_.m_135370_(TEXTURE));
    }

    public void setTexture(BalloonType value) {
        this.f_19804_.m_135381_(TEXTURE, (Object)value);
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        this.setRainbow(tag.m_128471_("rainbow"));
        this.setColor(tag.m_128451_("color"));
        this.setTexture(BalloonType.getTypeFromId(tag.m_128461_("texture")));
        this.rope = tag.m_128469_("rope");
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        tag.m_128379_("rainbow", this.isRainbow());
        tag.m_128405_("color", this.getColor());
        tag.m_128359_("texture", this.getTexture().id);
        if (this.holder != null) {
            CompoundTag ropeData = new CompoundTag();
            if (this.holder instanceof LivingEntity) {
                ropeData.m_128362_("uuid", this.holder.m_142081_());
            } else {
                Entity entity = this.holder;
                if (entity instanceof HangingEntity) {
                    HangingEntity decor = (HangingEntity)entity;
                    ropeData.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)decor.m_31748_()));
                }
            }
            tag.m_128365_("rope", (Tag)ropeData);
        } else if (this.rope != null) {
            tag.m_128365_("rope", (Tag)this.rope.m_6426_());
        }
    }

    private void readRopeData() {
        Level level;
        if (this.rope != null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.rope.m_128403_("uuid")) {
                Entity entity = server.m_8791_(this.rope.m_128342_("uuid"));
                if (entity != null) {
                    this.attachRope(entity);
                    return;
                }
            } else if (this.rope.m_128425_("pos", 10)) {
                BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)this.rope.m_128469_("pos"));
                LeashFenceKnotEntity orCreate = LeashFenceKnotEntity.m_31844_((Level)server, (BlockPos)blockPos);
                this.attachRope((Entity)orCreate);
                return;
            }
            if (this.f_19797_ > 100) {
                this.rope = null;
            }
        }
    }

    public void attachRope(Entity entity) {
        this.holder = entity;
        this.rope = null;
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(HOLDER_ID, (Object)entity.m_142049_());
        }
    }

    private void detachRope() {
        if (this.holder != null && this.f_19797_ > 100) {
            this.holder = null;
            this.rope = null;
            this.f_19804_.m_135381_(HOLDER_ID, (Object)0);
        }
    }

    @Nullable
    public Entity getHolder() {
        int holdingId = (Integer)this.f_19804_.m_135370_(HOLDER_ID);
        if (this.holder == null && holdingId != 0 && this.f_19853_.f_46443_) {
            this.holder = this.f_19853_.m_6815_(holdingId);
        }
        return this.holder;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

