/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.playdate.common.constants.BalloonType;
import tech.thatgravyboat.playdate.common.entity.BalloonEntity;
import tech.thatgravyboat.playdate.common.entity.ModEntities;
import tech.thatgravyboat.playdate.common.item.ModItems;
import tech.thatgravyboat.playdate.common.util.Color;

public class BalloonItem
extends Item
implements DyeableLeatherItem {
    private final BalloonType type;

    public BalloonItem(BalloonType type, Item.Properties p_41383_) {
        super(p_41383_);
        this.type = type;
    }

    public int m_41121_(@NotNull ItemStack stack) {
        return BalloonItem.isRainbow(stack) ? Color.RAINBOW.getRGBA() : super.m_41121_(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BalloonEntity balloonEntity = (BalloonEntity)((EntityType)ModEntities.BALLOON.get()).m_20655_(server, null, null, player, player.m_142538_().m_142082_(0, 3, 0), MobSpawnType.TRIGGERED, false, false);
            ItemStack stack = player.m_21120_(hand);
            CompoundTag tag = stack.m_41783_();
            if (balloonEntity != null) {
                float length = tag != null ? tag.m_128457_("length") : 0.0f;
                balloonEntity.setColor(this.m_41121_(stack));
                balloonEntity.setRainbow(BalloonItem.isRainbow(stack));
                balloonEntity.setTexture(this.type);
                balloonEntity.setRopeLength(length + 2.0f);
                level.m_7967_((Entity)balloonEntity);
                balloonEntity.attachRope((Entity)player);
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.ROPE.get())));
            }
        }
        return super.m_7203_(level, player, hand);
    }

    private static boolean isRainbow(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128471_("rainbow") || stack.m_41611_().getString().equals("jeb_");
    }
}

