/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.recipes;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.playdate.common.item.BalloonItem;
import tech.thatgravyboat.playdate.common.item.ModItems;
import tech.thatgravyboat.playdate.common.recipes.ModRecipes;

public class ExtendingRopeRecipe
extends CustomRecipe {
    public ExtendingRopeRecipe(ResourceLocation p_43833_) {
        super(p_43833_);
    }

    public boolean matches(@NotNull CraftingContainer craft, @NotNull Level level) {
        boolean foundBalloon = false;
        int length = 0;
        int ropes = 0;
        for (int i = 0; i < craft.m_6643_(); ++i) {
            ItemStack stack = craft.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.ROPE.get())) {
                ++ropes;
                continue;
            }
            if (stack.m_41720_() instanceof BalloonItem) {
                if (foundBalloon) {
                    return false;
                }
                foundBalloon = true;
                int n = length = stack.m_41783_() != null ? stack.m_41783_().m_128451_("length") : 0;
                if (length + ropes <= 8) continue;
                return false;
            }
            return false;
        }
        return length + ropes <= 8;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer craft) {
        ItemStack balloon = ItemStack.f_41583_;
        int length = 0;
        int ropes = 0;
        for (int i = 0; i < craft.m_6643_(); ++i) {
            ItemStack stack = craft.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.ROPE.get())) {
                ++ropes;
            }
            if (!(stack.m_41720_() instanceof BalloonItem)) continue;
            balloon = stack;
            length = stack.m_41783_() != null ? stack.m_41783_().m_128451_("length") : 0;
        }
        balloon = balloon.m_41777_();
        balloon.m_41784_().m_128405_("length", length + ropes);
        balloon.m_41764_(1);
        return balloon;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.EXTENDING_ROPE.get();
    }
}

