/*
 * Decompiled with CFR 0.152.
 */
package deathtags.api;

import deathtags.api.relation.EnumRelation;
import deathtags.core.MMOParties;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PartyHelper {

    public static class Server {
        public static MinecraftServer server;

        public static List<Party> GetParties() {
            ArrayList<Party> parties = new ArrayList<Party>();
            server.m_6846_().m_11314_().forEach(serverPlayerEntity -> {
                PlayerStats stats = MMOParties.GetStatsByName(serverPlayerEntity.m_7755_().getString());
                if (!stats.InParty() || stats.party.leader.m_7755_().getString() != serverPlayerEntity.m_7755_().getString()) {
                    return;
                }
                parties.add(stats.party);
            });
            return parties;
        }

        public static Party GetParty(ServerPlayer player) {
            return MMOParties.GetStatsByName((String)player.m_7755_().getString()).party;
        }

        public static EnumRelation GetRelation(ServerPlayer player, ServerPlayer target) {
            PlayerStats playerStats = MMOParties.GetStatsByName(player.m_7755_().m_6111_());
            if (playerStats.InParty() && playerStats.party.IsMember((Player)target)) {
                return EnumRelation.PARTY;
            }
            return EnumRelation.NONE;
        }
    }

    public static class Client {
        public static Party GetParty() {
            return MMOParties.localParty;
        }

        public static boolean IsPartyLeader() {
            return MMOParties.localParty.leader == Minecraft.m_91087_().f_91074_;
        }

        public static int PartySize() {
            if (Client.GetParty() == null) {
                return 0;
            }
            return Client.GetParty().local_players.size();
        }
    }
}

