/*
 * Decompiled with CFR 0.152.
 */
package deathtags.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.core.events.EventClient;
import deathtags.helpers.CommandMessageHelper;
import deathtags.networking.MessageOpenUI;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;

public class PartyCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"party").requires(commandSource -> true)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"sub", (ArgumentType)StringArgumentType.string()).executes(ctx -> PartyCommand.run((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"sub"), null))).suggests((sourceCommandContext, suggestionsBuilder) -> {
            suggestionsBuilder.suggest("invite").suggest("accept").suggest("deny").suggest("kick").suggest("leader").suggest("disband").suggest("gui");
            if (((Boolean)ConfigHolder.COMMON.allowPartyTP.get()).booleanValue()) {
                suggestionsBuilder.suggest("tp");
            }
            return suggestionsBuilder.buildFuture();
        }).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> PartyCommand.run((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"sub"), StringArgumentType.getString((CommandContext)ctx, (String)"player")))).suggests((sourceCommandContext, suggestionsBuilder) -> PartyCommand.getSuggestions((CommandContext<CommandSourceStack>)sourceCommandContext, suggestionsBuilder))));
    }

    private static CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        String argument;
        switch (argument = StringArgumentType.getString(ctx, (String)"sub").trim()) {
            case "invite": 
            case "kick": 
            case "leader": {
                ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11314_().forEach(player -> builder.suggest(player.m_7755_().getString()));
            }
        }
        return builder.buildFuture();
    }

    private static int run(CommandContext<CommandSourceStack> context, String sub, String targetStr) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Player target = null;
        if (targetStr != null) {
            ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(targetStr);
        }
        if (targetStr != null && target == null) {
            CommandMessageHelper.SendError((Player)player, String.format("The player %s is not online.", targetStr), new String[0]);
            return 0;
        }
        if (player.m_20193_().f_46443_) {
            return 0;
        }
        PlayerStats stats = MMOParties.GetStats((Player)player);
        switch (sub) {
            case "tp": {
                if (!((Boolean)ConfigHolder.COMMON.allowPartyTP.get()).booleanValue()) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.teleport.server", new String[0]);
                    return 0;
                }
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.teleport.party", new String[0]);
                    return 0;
                }
                stats.party.Teleport((Player)player, target);
                break;
            }
            case "kick": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.party", new String[0]);
                    return 0;
                }
                stats.party.Leave(target);
                break;
            }
            case "create": {
                Party.Create((Player)player);
                break;
            }
            case "invite": {
                if (targetStr == null) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.argument", player.m_7755_().m_6111_());
                    return 0;
                }
                if (!stats.InParty()) {
                    Party.Create((Player)player);
                }
                stats.party.Invite((Player)player, target);
                break;
            }
            case "accept": {
                if (stats.partyInvite == null) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.invite", new String[0]);
                    return 0;
                }
                stats.partyInvite.Join((Player)player, true);
                break;
            }
            case "deny": {
                if (stats.partyInvite == null) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.invite", new String[0]);
                    return 0;
                }
                stats.partyInvite = null;
                CommandMessageHelper.SendInfo((Player)player, "rpgparties.message.party.deny", new String[0]);
                break;
            }
            case "leave": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.party", new String[0]);
                    return 0;
                }
                stats.party.Leave((Player)player);
                stats.party = null;
                break;
            }
            case "leader": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((Player)player, "You are not currently in a party.", new String[0]);
                    return 0;
                }
                if (stats.party.leader != player) {
                    CommandMessageHelper.SendError((Player)player, "Only the leader may promote members.", new String[0]);
                    return 0;
                }
                if (targetStr == null) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.argument", player.m_7755_().m_6111_());
                    return 0;
                }
                stats.party.MakeLeader((Player)player);
                break;
            }
            case "disband": {
                if (!stats.InParty()) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.party", new String[0]);
                    return 0;
                }
                if (stats.party.leader != player) {
                    CommandMessageHelper.SendError((Player)player, "rpgparties.message.error.disband", new String[0]);
                    return 0;
                }
                stats.party.Disband();
                break;
            }
            case "gui": {
                if (!player.m_20193_().f_46443_) {
                    MMOParties.network.sendTo((Object)new MessageOpenUI(), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    break;
                }
                if (!Minecraft.m_91087_().m_91091_()) break;
                EventClient.openScreen();
                break;
            }
        }
        return 0;
    }
}

