/*
 * Decompiled with CFR 0.152.
 */
package deathtags.core;

import com.mojang.blaze3d.platform.InputConstants;
import deathtags.api.PartyHelper;
import deathtags.commands.PartyCommand;
import deathtags.config.ConfigHolder;
import deathtags.core.events.EventClient;
import deathtags.core.events.EventCommon;
import deathtags.core.events.EventServer;
import deathtags.gui.HealthBar;
import deathtags.networking.MessageGUIInvitePlayer;
import deathtags.networking.MessageOpenUI;
import deathtags.networking.MessageSendMemberData;
import deathtags.networking.MessageUpdateParty;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="mmoparties")
public class MMOParties {
    public static final String MODID = "mmoparties";
    public static Party localParty = null;
    public static Map<Player, PlayerStats> PlayerStats = new HashMap<Player, PlayerStats>();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("mmoparties", "sync")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
    public static KeyMapping OPEN_GUI_KEY;

    public MMOParties() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHolder.COMMON_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
        MinecraftForge.EVENT_BUS.addListener(this::serverInit);
        MinecraftForge.EVENT_BUS.addListener(this::serverInitEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void preInit(FMLCommonSetupEvent event) {
        System.out.println("mmoparties is pre-loading!");
        network.registerMessage(1, MessageUpdateParty.class, MessageUpdateParty::encode, MessageUpdateParty::decode, MessageUpdateParty.Handler::handle);
        network.registerMessage(2, MessageSendMemberData.class, MessageSendMemberData::encode, MessageSendMemberData::decode, MessageSendMemberData.Handler::handle);
        network.registerMessage(3, MessageGUIInvitePlayer.class, MessageGUIInvitePlayer::encode, MessageGUIInvitePlayer::decode, MessageGUIInvitePlayer.Handler::handle);
        MinecraftForge.EVENT_BUS.register((Object)new EventCommon());
        MinecraftForge.EVENT_BUS.register((Object)new EventClient());
        MinecraftForge.EVENT_BUS.register((Object)new EventServer());
    }

    public void serverInitEvent(ServerStartingEvent event) {
        PartyHelper.Server.server = event.getServer();
    }

    public void clientInit(FMLClientSetupEvent event) {
        HealthBar.init();
        network.registerMessage(4, MessageOpenUI.class, MessageOpenUI::encode, MessageOpenUI::decode, MessageOpenUI.Handler::handle);
        OPEN_GUI_KEY = new KeyMapping("key.opengui.desc", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, 80, "key.mmoparties.category");
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_GUI_KEY);
    }

    public void serverInit(RegisterCommandsEvent event) {
        event.getDispatcher().register(PartyCommand.register());
        network.registerMessage(4, MessageOpenUI.class, MessageOpenUI::encode, MessageOpenUI::decode, MessageOpenUI.Handler::handleServer);
    }

    public static PlayerStats GetStatsByName(String name) {
        for (Map.Entry<Player, PlayerStats> plr : PlayerStats.entrySet()) {
            if (!plr.getKey().m_7755_().m_6111_().equals(name)) continue;
            return plr.getValue();
        }
        return null;
    }

    public static PlayerStats GetStats(Player player) {
        return MMOParties.GetStatsByName(player.m_7755_().getString());
    }
}

