/*
 * Decompiled with CFR 0.152.
 */
package deathtags.core.events;

import deathtags.api.PartyHelper;
import deathtags.api.relation.EnumRelation;
import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventCommon {
    public static Party globalParty = null;

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!MMOParties.PlayerStats.containsKey(player)) {
            MMOParties.PlayerStats.put(player, new PlayerStats(player));
        }
        event.getPlayer().m_20194_().m_6846_().m_11314_().forEach(serverPlayer -> {
            PlayerStats ply = MMOParties.GetStats((Player)serverPlayer);
            if (ply.InParty() && !MMOParties.GetStats(player).InParty() && ply.party.IsMemberOffline(player)) {
                ply.party.Join(player, false);
                return;
            }
        });
        if (!((Boolean)ConfigHolder.COMMON.autoAssignParties.get()).booleanValue()) {
            return;
        }
        if (globalParty == null) {
            globalParty = Party.CreateGlobalParty(player);
        } else if (!globalParty.IsMember(player)) {
            globalParty.Join(event.getPlayer(), true);
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerStats playerStats = MMOParties.GetStatsByName(event.getPlayer().m_7755_().getString());
        if (playerStats.InParty()) {
            playerStats.party.players.remove(event.getPlayer());
            if (playerStats.party.players.size() > 0) {
                playerStats.party.MakeLeader(playerStats.party.players.get(0));
            }
        }
        MMOParties.PlayerStats.remove(event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void OnPlayerHurt(LivingHurtEvent event) {
        Player source;
        if (!((Boolean)ConfigHolder.COMMON.friendlyFireDisabled.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().m_20193_().f_46443_) {
            return;
        }
        if (!(event.getEntityLiving() instanceof Player) || !(event.getSource().m_7640_() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntityLiving();
        if (PartyHelper.Server.GetRelation((ServerPlayer)player, (ServerPlayer)(source = (Player)event.getSource().m_7640_())) == EnumRelation.PARTY) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void OnPlayerMove(TickEvent.PlayerTickEvent event) {
        if (event.player.m_20193_().f_46443_) {
            return;
        }
        Player player = event.player;
        PlayerStats stats = MMOParties.GetStatsByName(player.m_7755_().m_6111_());
        if (stats == null) {
            return;
        }
        stats.TickTeleport();
        if (stats.party != null) {
            MMOParties.PlayerStats.get((Object)player).party.SendPartyMemberData(player, false);
        }
    }
}

