/*
 * Decompiled with CFR 0.152.
 */
package deathtags.networking;

import com.google.common.base.Charsets;
import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.networking.EnumPartyGUIAction;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageGUIInvitePlayer {
    public final String name;
    public final EnumPartyGUIAction action;

    public MessageGUIInvitePlayer(CharSequence charSequence, EnumPartyGUIAction action) {
        this.name = charSequence.toString();
        this.action = action;
    }

    public static MessageGUIInvitePlayer decode(ByteBuf buf) {
        return new MessageGUIInvitePlayer(buf.readCharSequence(buf.readInt(), Charsets.UTF_8), EnumPartyGUIAction.values()[buf.readInt()]);
    }

    public static void encode(MessageGUIInvitePlayer msg, ByteBuf buf) {
        buf.writeInt(msg.name.length());
        buf.writeCharSequence((CharSequence)msg.name, Charsets.UTF_8);
        buf.writeInt(msg.action.ordinal());
    }

    public static class Handler {
        public static void handle(MessageGUIInvitePlayer pkt, Supplier<NetworkEvent.Context> ctx) {
            System.out.println("Party invite GUI interaction received");
            System.out.println(pkt);
            PlayerStats stats = MMOParties.GetStatsByName(ctx.get().getSender().m_7755_().getString());
            switch (pkt.action) {
                case INVITE: {
                    if (!stats.InParty()) {
                        stats.party = new Party((Player)ctx.get().getSender());
                    }
                    if (pkt.name == "" && ((Boolean)ConfigHolder.COMMON.allowInviteAll.get()).booleanValue()) {
                        ctx.get().getSender().f_8924_.m_6846_().m_11314_().forEach(serverPlayerEntity -> stats.party.Invite((Player)((NetworkEvent.Context)ctx.get()).getSender(), (Player)serverPlayerEntity));
                        break;
                    }
                    stats.party.Invite((Player)ctx.get().getSender(), (Player)ctx.get().getSender().f_8924_.m_6846_().m_11255_(pkt.name));
                    break;
                }
                case KICK: {
                    if (!stats.InParty()) {
                        return;
                    }
                    stats.party.Leave((Player)ctx.get().getSender().f_8924_.m_6846_().m_11255_(pkt.name));
                    break;
                }
                case LEADER: {
                    if (!stats.InParty()) {
                        return;
                    }
                    stats.party.MakeLeader((Player)ctx.get().getSender().f_8924_.m_6846_().m_11255_(pkt.name));
                    break;
                }
                case DISBAND: {
                    if (!stats.InParty()) {
                        return;
                    }
                    stats.party.Disband();
                    break;
                }
                case LEAVE: {
                    if (!stats.InParty()) {
                        return;
                    }
                    stats.Leave();
                }
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

