/*
 * Decompiled with CFR 0.152.
 */
package deathtags.stats;

import deathtags.config.ConfigHolder;
import deathtags.core.MMOParties;
import deathtags.helpers.CommandMessageHelper;
import deathtags.networking.MessageSendMemberData;
import deathtags.networking.MessageUpdateParty;
import deathtags.networking.PartyPacketDataBuilder;
import deathtags.stats.PartyMemberData;
import deathtags.stats.PlayerGroup;
import deathtags.stats.PlayerPing;
import deathtags.stats.PlayerStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;

public class Party
extends PlayerGroup {
    public List<Player> players = new ArrayList<Player>();
    public List<String> playersOffline = new ArrayList<String>();
    public List<String> local_players = new ArrayList<String>();
    public Map<String, PartyMemberData> data = new HashMap<String, PartyMemberData>();

    public Party(Player player) {
        this.leader = player;
        this.players.add(player);
        this.playersOffline.add(player.m_7755_().getString());
        this.SendUpdate();
    }

    public Party() {
    }

    public static Party Create(Player leader) {
        PlayerStats stats = MMOParties.GetStatsByName(leader.m_7755_().m_6111_());
        if (stats.InParty()) {
            CommandMessageHelper.SendError(leader, "rpgparties.message.party.exists", new String[0]);
            return stats.party;
        }
        stats.party = new Party(leader);
        CommandMessageHelper.SendInfo(leader, "rpgparties.message.party.create", new String[0]);
        return stats.party;
    }

    public static Party CreateGlobalParty(Player player) {
        PlayerStats stats = MMOParties.GetStatsByName(player.m_7755_().m_6111_());
        if (stats.InParty()) {
            CommandMessageHelper.SendError(player, "rpgparties.message.party.exists", new String[0]);
            return stats.party;
        }
        stats.party = new Party(player);
        stats.party.leader = null;
        CommandMessageHelper.SendInfo(player, "rpgparties.message.party.create", new String[0]);
        return stats.party;
    }

    public void Invite(Player invoker, Player player) {
        PlayerStats targetPlayer = MMOParties.GetStats(player);
        PlayerStats invokerPlayer = MMOParties.GetStats(invoker);
        if (invokerPlayer.party.leader != invoker) {
            CommandMessageHelper.SendError(invoker, "rpgparties.message.party.privilege", new String[0]);
            return;
        }
        targetPlayer.partyInvite = this;
        CommandMessageHelper.SendInfo(invoker, "rpgparties.message.party.invited", player.m_7755_().m_6111_());
        CommandMessageHelper.SendInfoWithButton(player, "rpgparties.message.party.invite.from", invoker.m_7755_().m_6111_());
    }

    public void Join(Player player, boolean displayMessage) {
        if (this.players.size() >= 4) {
            CommandMessageHelper.SendError(player, "rpgparties.message.party.full", new String[0]);
            return;
        }
        this.players.add(player);
        this.playersOffline.add(player.m_7755_().getString());
        PlayerStats stats = MMOParties.GetStatsByName(player.m_7755_().m_6111_());
        stats.party = this;
        stats.partyInvite = null;
        if (displayMessage) {
            this.Broadcast(new TranslatableComponent("rpgparties.message.party.joined", new Object[]{player.m_7755_().m_6111_()}));
        }
        for (Player member : this.players) {
            this.SendPartyMemberData(member, true);
        }
        this.SendUpdate();
    }

    public void Leave(Player player) {
        this.players.remove(player);
        this.Broadcast(new TranslatableComponent("rpgparties.message.party.player.left", new Object[]{player.m_7755_().m_6111_()}));
        for (Player member : this.players) {
            this.SendPartyMemberData(member, true);
        }
        this.SendPartyMemberData(player, true);
        if (player == this.leader && this.players.size() > 0) {
            this.leader = this.players.get(0);
        }
        this.SendUpdate();
        MMOParties.GetStats((Player)player).party = null;
        MMOParties.network.sendTo((Object)new MessageUpdateParty(""), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        if (this.players.size() == 1 && !((Boolean)ConfigHolder.COMMON.autoAssignParties.get()).booleanValue()) {
            this.Disband();
        }
        CommandMessageHelper.SendInfo(player, "rpgparties.message.party.leave", new String[0]);
    }

    public void Disband() {
        this.Broadcast(new TranslatableComponent("rpgparties.message.party.disbanded"));
        this.leader = null;
        for (Player member : this.players) {
            PlayerStats stats = MMOParties.GetStatsByName(member.m_7755_().m_6111_());
            stats.party = null;
            MMOParties.network.sendTo((Object)new MessageUpdateParty(""), ((ServerPlayer)member).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        this.players.clear();
    }

    @Override
    public void Broadcast(TranslatableComponent message) {
        for (Player member : this.players) {
            member.m_5661_((Component)message, false);
        }
    }

    @Override
    public Player[] GetOnlinePlayers() {
        return this.players.toArray(new Player[0]);
    }

    @Override
    public void SendUpdate() {
        CharSequence[] playerNames = new String[this.players.size()];
        int i = 0;
        for (Player party_player : this.players) {
            playerNames[i] = party_player.m_7755_().m_6111_();
            ++i;
        }
        for (Player party_player : this.players) {
            if (!(party_player instanceof ServerPlayer)) {
                return;
            }
            MMOParties.network.sendTo((Object)new MessageUpdateParty(String.join((CharSequence)",", playerNames)), ((ServerPlayer)party_player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @Override
    public void SendPartyMemberData(Player member, boolean bypassLimit) {
        if (this.IsDataDifferent(member) || bypassLimit) {
            if (!this.pings.containsKey(member.m_7755_().m_6111_())) {
                this.pings.put(member.m_7755_().m_6111_(), new PlayerPing(member, 0.0f, 0.0f, 0.0f, bypassLimit, 0.0f, 0.0f, 0.0f, 0.0f));
            }
            ((PlayerPing)this.pings.get(member.m_7755_().m_6111_())).Update(member.m_21223_(), member.m_21233_(), member.m_21230_(), this.leader == member, member.m_6103_(), 0.0f, 0.0f);
            for (Player party_player : this.players) {
                if (!(party_player instanceof ServerPlayer)) {
                    return;
                }
                MMOParties.network.sendTo((Object)new MessageSendMemberData(new PartyPacketDataBuilder().SetPlayer(member.m_7755_().m_6111_()).SetHealth(member.m_21223_()).SetMaxHealth(member.m_21233_()).SetArmor(member.m_21230_()).SetLeader(this.leader == member).SetAbsorption(member.m_6103_()).SetHunger(member.m_36324_().m_38702_())), ((ServerPlayer)party_player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @Override
    public boolean IsDataDifferent(Player player) {
        return !this.pings.containsKey(player.m_7755_().m_6111_()) || ((PlayerPing)this.pings.get(player.m_7755_().m_6111_())).IsDifferent(player);
    }

    @Override
    public boolean IsMember(Player player) {
        for (Player member : this.players) {
            if (!member.m_7755_().equals(player.m_7755_())) continue;
            return true;
        }
        return false;
    }

    public boolean IsMemberOffline(Player player) {
        return this.playersOffline.contains(player.m_7755_().getString());
    }

    @Override
    public String GetGroupAlias() {
        return "party";
    }

    public void Teleport(Player player, Player target) {
        if (!this.IsMember(target)) {
            CommandMessageHelper.SendError(player, "rpgparties.message.error.party", new String[0]);
            return;
        }
        MMOParties.GetStatsByName(player.m_7755_().m_6111_()).StartTeleport(target);
    }
}

