/*
 * Decompiled with CFR 0.152.
 */
package deathtags.api;

import deathtags.api.relation.EnumRelation;
import deathtags.core.MMOParties;
import deathtags.stats.Party;
import deathtags.stats.PlayerStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class PartyHelper {

    public static class Server {
        public static MinecraftServer server;

        public static List<Party> GetParties() {
            ArrayList<Party> parties = new ArrayList<Party>();
            server.func_184103_al().func_181057_v().forEach(serverPlayerEntity -> {
                PlayerStats stats = MMOParties.GetStatsByName(serverPlayerEntity.func_70005_c_());
                if (!stats.InParty() || stats.party.leader.func_70005_c_() != serverPlayerEntity.func_70005_c_()) {
                    return;
                }
                parties.add(stats.party);
            });
            return parties;
        }

        public static Party GetParty(EntityPlayerMP player) {
            return MMOParties.GetStatsByName((String)player.func_70005_c_()).party;
        }

        public static EnumRelation GetRelation(EntityPlayerMP player, EntityPlayerMP target) {
            PlayerStats playerStats = MMOParties.GetStatsByName(player.func_70005_c_());
            if (playerStats.InParty() && playerStats.party.IsMember((EntityPlayer)target)) {
                return EnumRelation.PARTY;
            }
            return EnumRelation.NONE;
        }
    }

    public static class Client {
        public static Party GetParty() {
            return MMOParties.localParty;
        }

        public static boolean IsPartyLeader() {
            return MMOParties.localParty.leader == Minecraft.func_71410_x().field_71439_g;
        }

        public static int PartySize() {
            if (Client.GetParty() == null) {
                return 0;
            }
            return Client.GetParty().local_players.size();
        }
    }
}

